/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import com.google.common.truth.Truth;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataQuery;
import io.neonbee.internal.codec.DataQueryMessageCodec;
import io.vertx.core.buffer.Buffer;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.junit.jupiter.api.Test;

class DataQueryMessageCodecTest {
    private final DataQueryMessageCodec codec = new DataQueryMessageCodec();
    private final DataQuery query = new DataQuery(DataAction.UPDATE, "uri", "query1=value", Map.of("header1", List.of("value1")), Buffer.buffer((String)"body"));

    DataQueryMessageCodecTest() {
    }

    @Test
    void testEncode() throws JSONException {
        Buffer buffer = Buffer.buffer();
        this.codec.encodeToWire(buffer, this.query);
        DataQuery decoded = this.codec.decodeFromWire(0, buffer);
        Truth.assertThat((Object)decoded).isEqualTo((Object)this.query);
    }

    @Test
    void testTransform() {
        Truth.assertThat((Object)this.codec.transform(this.query)).isEqualTo((Object)this.query);
        Truth.assertThat((Object)this.codec.transform(this.query)).isNotSameInstanceAs((Object)this.query);
    }

    @Test
    void testName() {
        Truth.assertThat((String)this.codec.name()).isEqualTo((Object)"dataquery");
    }

    @Test
    void testSystemCodecID() {
        Truth.assertThat((Comparable)Byte.valueOf(this.codec.systemCodecID())).isEqualTo((Object)-1);
    }
}

