/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.codec;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.internal.codec.EntityWrapperMessageCodec;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.ResourceHelper;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class EntityWrapperMessageCodecTest
extends NeonBeeTestBase {
    private final Entity entity = new Entity().addProperty(new Property(null, "name", ValueType.PRIMITIVE, (Object)"NAME")).addProperty(new Property(null, "description", ValueType.PRIMITIVE, (Object)"DESCRIPTION")).addProperty(new Property(null, "ID", ValueType.PRIMITIVE, (Object)"ID"));
    private final EntityWrapper wrapper = new EntityWrapper("io.neonbee.codec.CodecService.TestUsers", this.entity);
    private EntityWrapperMessageCodec codec;

    EntityWrapperMessageCodecTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        return WorkingDirectoryBuilder.standard().addModel(ResourceHelper.TEST_RESOURCES.resolveRelated("CodecService.csn"));
    }

    @BeforeEach
    void setUp() {
        this.codec = new EntityWrapperMessageCodec(this.getNeonBee().getVertx());
    }

    @Test
    @DisplayName(value="Should serialize and deserialize an EntityWrapper correctly.")
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void encodeDecode(VertxTestContext testContext) {
        this.getNeonBee().getModelManager().reloadModels().compose(map -> {
            Buffer buffer = Buffer.buffer();
            this.codec.encodeToWire(buffer, this.wrapper);
            EntityWrapper decodeFromWire = this.codec.decodeFromWire(0, buffer);
            Truth.assertThat((String)decodeFromWire.getTypeName().getNamespace()).isEqualTo((Object)"io.neonbee.codec.CodecService");
            Truth.assertThat((String)decodeFromWire.getTypeName().getName()).isEqualTo((Object)"TestUsers");
            Entity decodedEntity = decodeFromWire.getEntity();
            Truth.assertThat((Object)decodedEntity.getProperty("name").getValue()).isEqualTo((Object)"NAME");
            Truth.assertThat((Object)decodedEntity.getProperty("description").getValue()).isEqualTo((Object)"DESCRIPTION");
            Truth.assertThat((Object)decodedEntity.getProperty("ID").getValue()).isEqualTo((Object)"ID");
            return Future.succeededFuture(null);
        }).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @DisplayName(value="Transform should return the same object")
    void testTransform() {
        Truth.assertThat((Object)this.codec.transform(this.wrapper)).isSameInstanceAs((Object)this.wrapper);
    }

    @Test
    void testSystemCodecID() {
        Truth.assertThat((Comparable)Byte.valueOf(this.codec.systemCodecID())).isEqualTo((Object)-1);
    }

    @Test
    void testName() {
        Truth.assertThat((String)this.codec.name()).isEqualTo((Object)"entitywrapper");
    }
}

