/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.internal.deploy.Deployable;
import io.neonbee.internal.deploy.PendingDeployment;
import io.vertx.core.Future;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class DeployableTest {
    DeployableTest() {
    }

    @Test
    @DisplayName(value="test Deployable getters")
    void testGetters() {
        DeployableThing deployable1 = new DeployableThing("foo");
        Truth.assertThat((String)deployable1.getIdentifier()).isEqualTo((Object)"foo");
        Truth.assertThat((String)deployable1.getType()).isEqualTo((Object)"Thing");
        DeployableThing deployable2 = new DeployableThing("foo");
        Truth.assertThat((String)deployable2.getIdentifier()).isEqualTo((Object)"foo");
        Truth.assertThat((String)deployable2.getType()).isEqualTo((Object)"Thing");
    }

    @Test
    @DisplayName(value="test toString of Deployable")
    void testToString() {
        Truth.assertThat((String)new DeployableThing("foo").toString()).isEqualTo((Object)"Thing(foo)");
        Truth.assertThat((String)new DeployableThing("bar").toString()).isEqualTo((Object)"Thing(bar)");
    }

    @Test
    @DisplayName(value="test deploy/undeploy of Deployable")
    void testDeployUndeploy() {
        DeployableThing deployable = new DeployableThing("foo");
        Truth.assertThat((Boolean)deployable.deploy(null).succeeded()).isTrue();
        Truth.assertThat((Boolean)deployable.deploy(null).undeploy().succeeded()).isTrue();
        deployable.undeployFuture = Future.failedFuture((String)"foo");
        Truth.assertThat((Boolean)deployable.deploy(null).succeeded()).isTrue();
        Truth.assertThat((Boolean)deployable.deploy(null).undeploy().failed()).isTrue();
        deployable.deployFuture = Future.failedFuture((String)"foo");
        Truth.assertThat((Boolean)deployable.deploy(null).failed()).isTrue();
    }

    static class DeployableThing
    extends Deployable {
        public String identifier;
        public Future<String> deployFuture;
        public Future<Void> undeployFuture;
        public boolean deploying;
        public boolean undeploying;

        DeployableThing(String identifier) {
            this.identifier = identifier;
            this.reset();
        }

        public final void reset() {
            this.undeploying = false;
            this.deploying = false;
            this.deployFuture = Future.succeededFuture();
            this.undeployFuture = Future.succeededFuture();
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public PendingDeployment deploy(NeonBee neonBee) {
            this.deploying = true;
            return new PendingDeployment(neonBee, this, this.deployFuture){

                protected Future<Void> undeploy(String deploymentId) {
                    undeploying = true;
                    return undeployFuture;
                }
            };
        }
    }
}

