/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.internal.NeonBeeModuleJar;
import io.neonbee.internal.deploy.DeployableVerticle;
import io.neonbee.internal.deploy.PendingDeployment;
import io.neonbee.internal.scanner.ClassPathScanner;
import io.neonbee.test.helper.DummyVerticleHelper;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DeployableVerticleTest {
    DeployableVerticleTest() {
    }

    @Test
    @DisplayName(value="test instantiation")
    void testInstantiation() {
        DeploymentOptions options = new DeploymentOptions();
        DeployableVerticle deployable1 = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE, options);
        Truth.assertThat((Class)deployable1.verticleClass).isNull();
        Truth.assertThat((Object)deployable1.verticleInstance).isSameInstanceAs((Object)DummyVerticleHelper.DUMMY_VERTICLE);
        Truth.assertThat((Object)deployable1.options).isEqualTo((Object)options);
        DeployableVerticle deployable2 = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE.getClass(), options);
        Truth.assertThat((Class)deployable2.verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Truth.assertThat((Object)deployable2.verticleInstance).isNull();
        Truth.assertThat((Object)deployable2.options).isEqualTo((Object)options);
    }

    @Test
    @DisplayName(value="test getIdentifier")
    void testGetIdentifier() {
        DeploymentOptions options = new DeploymentOptions();
        DeployableVerticle deployable1 = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE, options);
        Truth.assertThat((String)deployable1.getIdentifier()).isEqualTo((Object)DummyVerticleHelper.DUMMY_VERTICLE.getClass().getName());
        DeployableVerticle deployable2 = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE.getClass(), options);
        Truth.assertThat((String)deployable2.getIdentifier()).isEqualTo((Object)DummyVerticleHelper.DUMMY_VERTICLE.getClass().getName());
    }

    @Test
    @DisplayName(value="test deploy and undeploy")
    void testDeployUndeploy() {
        DeploymentOptions options = new DeploymentOptions();
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setIgnoreClassPath(true));
        DeployableVerticle deployable1 = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE, options);
        Truth.assertThat((String)deployable1.getIdentifier()).isEqualTo((Object)DummyVerticleHelper.DUMMY_VERTICLE.getClass().getName());
        PendingDeployment deployment1 = deployable1.deploy(neonBee);
        Truth.assertThat((Boolean)deployment1.succeeded()).isTrue();
        ((Vertx)Mockito.verify((Object)vertxMock)).deployVerticle(DummyVerticleHelper.DUMMY_VERTICLE, deployable1.options);
        Truth.assertThat((Boolean)deployment1.undeploy().succeeded()).isTrue();
        ((Vertx)Mockito.verify((Object)vertxMock)).undeploy((String)ArgumentMatchers.any());
        DeployableVerticle deployable2 = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE.getClass(), options);
        Truth.assertThat((String)deployable2.getIdentifier()).isEqualTo((Object)DummyVerticleHelper.DUMMY_VERTICLE.getClass().getName());
        PendingDeployment deployment2 = deployable2.deploy(neonBee);
        Truth.assertThat((Boolean)deployment2.succeeded()).isTrue();
        ((Vertx)Mockito.verify((Object)vertxMock)).deployVerticle(DummyVerticleHelper.DUMMY_VERTICLE.getClass(), deployable2.options);
        Truth.assertThat((Boolean)deployment2.undeploy().succeeded()).isTrue();
        ((Vertx)Mockito.verify((Object)vertxMock, (VerificationMode)Mockito.times((int)2))).undeploy((String)ArgumentMatchers.any());
    }

    @Test
    @DisplayName(value="test deploy failed")
    void testDeployFailed() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setIgnoreClassPath(true));
        Mockito.when((Object)vertxMock.deployVerticle((Verticle)ArgumentMatchers.any(Verticle.class), (DeploymentOptions)ArgumentMatchers.any(DeploymentOptions.class))).thenReturn((Object)Future.failedFuture((String)"any failure"));
        DeployableVerticle deployable = new DeployableVerticle(DummyVerticleHelper.DUMMY_VERTICLE, new DeploymentOptions());
        PendingDeployment deployment = deployable.deploy(neonBee);
        Truth.assertThat((Boolean)deployment.failed()).isTrue();
        Truth.assertThat((Throwable)deployment.cause()).hasMessageThat().isEqualTo((Object)"any failure");
        Truth.assertThat((Boolean)deployment.undeploy().succeeded()).isTrue();
    }

    @Test
    @DisplayName(value="test read not found verticle config")
    void testReadVerticleConfigNotFound() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Truth.assertThat((Iterable)((DeploymentOptions)DeployableVerticle.readVerticleConfig((Vertx)vertxMock, (String)"test", null).result()).toJson()).isEqualTo((Object)new DeploymentOptions().toJson());
        InOrder orderVerifier = Mockito.inOrder((Object[])new Object[]{fileSystemMock});
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.yaml").toAbsolutePath().toString());
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.yml").toAbsolutePath().toString());
        ((FileSystem)orderVerifier.verify((Object)fileSystemMock)).readFile(Path.of("config", new String[0]).resolve("test.json").toAbsolutePath().toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{fileSystemMock});
    }

    @Test
    @DisplayName(value="test read not found verticle config not found with default")
    void testReadVerticleConfigNotFoundWithDefault() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        JsonObject defaultObject = new JsonObject().put("ha", (Object)true);
        Truth.assertThat((Iterable)((DeploymentOptions)DeployableVerticle.readVerticleConfig((Vertx)vertxMock, (String)"test", (JsonObject)defaultObject).result()).toJson()).isEqualTo((Object)new DeploymentOptions().setHa(true).toJson());
    }

    @Test
    @DisplayName(value="test read verticle config")
    void testReadVerticleConfig() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Mockito.when((Object)fileSystemMock.readFile(ArgumentMatchers.endsWith((String)".yml"))).thenReturn((Object)Future.succeededFuture((Object)Buffer.buffer((String)"---\nha: true\nworkerPoolName: Test")));
        Truth.assertThat((Iterable)((DeploymentOptions)DeployableVerticle.readVerticleConfig((Vertx)vertxMock, (String)"test", null).result()).toJson()).isEqualTo((Object)new DeploymentOptions().setHa(true).setWorkerPoolName("Test").toJson());
    }

    @Test
    @DisplayName(value="test read verticle config with default")
    void testReadVerticleConfigWithDefault() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Mockito.when((Object)fileSystemMock.readFile(ArgumentMatchers.endsWith((String)".yml"))).thenReturn((Object)Future.succeededFuture((Object)Buffer.buffer((String)"---\nha: true\nworkerPoolName: Test")));
        JsonObject defaultObject = new JsonObject().put("ha", (Object)false).put("instances", (Object)1337);
        Truth.assertThat((Iterable)((DeploymentOptions)DeployableVerticle.readVerticleConfig((Vertx)vertxMock, (String)"test", (JsonObject)defaultObject).result()).toJson()).isEqualTo((Object)new DeploymentOptions().setHa(true).setWorkerPoolName("Test").setInstances(1337).toJson());
    }

    @Test
    @DisplayName(value="test read verticle config failure")
    void testReadVerticleConfigFailure() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        FileSystem fileSystemMock = vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock, (NeonBeeOptions)new NeonBeeOptions.Mutable().setWorkingDirectory(Path.of("", new String[0])));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.failedFuture((Throwable)new FileSystemException((Throwable)new NoSuchFileException("file"))));
        Mockito.when((Object)fileSystemMock.readFile(ArgumentMatchers.endsWith((String)".yml"))).thenReturn((Object)Future.failedFuture((String)"test"));
        JsonObject defaultObject = new JsonObject().put("ha", (Object)false).put("instances", (Object)1337);
        Truth.assertThat((Throwable)DeployableVerticle.readVerticleConfig((Vertx)vertxMock, (String)"test", (JsonObject)defaultObject).cause()).hasMessageThat().isEqualTo((Object)"test");
    }

    @Test
    @DisplayName(value="test scan class path")
    void testScanClassPath() throws ClassNotFoundException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        ClassPathScanner classPathScannerMock = (ClassPathScanner)Mockito.mock(ClassPathScanner.class);
        Mockito.when((Object)classPathScannerMock.scanManifestFiles((Vertx)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture(List.of("entry", "entry2")));
        ClassLoader classLoaderMock = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when((Object)classPathScannerMock.getClassLoader()).thenReturn((Object)classLoaderMock);
        Mockito.when(classLoaderMock.loadClass((String)ArgumentMatchers.any())).thenReturn(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Future deployable = DeployableVerticle.scanClassPath((Vertx)vertxMock, (ClassPathScanner)classPathScannerMock, (ClassLoader)classLoaderMock);
        Truth.assertThat((Throwable)deployable.cause()).isNull();
        Truth.assertThat((Boolean)deployable.succeeded()).isTrue();
        ((ClassPathScanner)Mockito.verify((Object)classPathScannerMock)).scanManifestFiles(vertxMock, "NeonBee-Deployables");
        ((ClassLoader)Mockito.verify((Object)classLoaderMock)).loadClass("entry");
        ((ClassLoader)Mockito.verify((Object)classLoaderMock)).loadClass("entry2");
        ArrayList verticles = new ArrayList((Collection)deployable.result());
        Truth.assertThat(verticles).hasSize(2);
        Truth.assertThat((Class)((DeployableVerticle)verticles.get((int)0)).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Truth.assertThat((Class)((DeployableVerticle)verticles.get((int)1)).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
    }

    @Test
    @DisplayName(value="test from JAR")
    void testFromJar() throws IOException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        NeonBeeModuleJar moduleJar = NeonBeeModuleJar.create("testmodule").withVerticles().build();
        Path moduleJarPath = moduleJar.writeToTempPath();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{moduleJarPath.toUri().toURL()}, ClassLoader.getSystemClassLoader());
        Future deployable = DeployableVerticle.fromJar((Vertx)vertxMock, (Path)moduleJarPath, (ClassLoader)classLoader);
        Truth.assertThat((Throwable)deployable.cause()).isNull();
        Truth.assertThat((Boolean)deployable.succeeded()).isTrue();
        ArrayList verticles = new ArrayList((Collection)deployable.result());
        Truth8.assertThat(verticles.stream().map(deployableVerticle -> deployableVerticle.verticleClass).map(Class::getSimpleName)).containsExactly(new Object[]{"ClassA", "ClassB"});
    }

    @Test
    @DisplayName(value="test from class name")
    void testFromClassName() throws ClassNotFoundException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        JsonObject config = new JsonObject().put("config", (Object)new JsonObject().put("foo", (Object)"bar"));
        Future deployable1 = DeployableVerticle.fromClassName((Vertx)vertxMock, (String)DummyVerticleHelper.DUMMY_VERTICLE.getClass().getName());
        Truth.assertThat((Boolean)deployable1.succeeded()).isTrue();
        Truth.assertThat((Class)((DeployableVerticle)deployable1.result()).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Future deployable2 = DeployableVerticle.fromClassName((Vertx)vertxMock, (String)DummyVerticleHelper.DUMMY_VERTICLE.getClass().getName(), (JsonObject)config);
        Truth.assertThat((Boolean)deployable2.succeeded()).isTrue();
        Truth.assertThat((Class)((DeployableVerticle)deployable2.result()).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Truth.assertThat((Iterable)((DeployableVerticle)deployable2.result()).options.getConfig()).isEqualTo((Object)config.getJsonObject("config"));
        ClassLoader classLoaderMock = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when(classLoaderMock.loadClass((String)ArgumentMatchers.any())).thenReturn(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Future deployable3 = DeployableVerticle.fromClassName((Vertx)vertxMock, (String)"test", (ClassLoader)classLoaderMock);
        Truth.assertThat((Boolean)deployable3.succeeded()).isTrue();
        Truth.assertThat((Class)((DeployableVerticle)deployable3.result()).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Future deployable4 = DeployableVerticle.fromClassName((Vertx)vertxMock, (String)"test", (ClassLoader)classLoaderMock, (JsonObject)config);
        Truth.assertThat((Boolean)deployable4.succeeded()).isTrue();
        Truth.assertThat((Class)((DeployableVerticle)deployable4.result()).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Truth.assertThat((Iterable)((DeployableVerticle)deployable4.result()).options.getConfig()).isEqualTo((Object)config.getJsonObject("config"));
    }

    @Test
    @DisplayName(value="test from wrong class name")
    void testFromWrongClassName() throws ClassNotFoundException {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        ClassLoader classLoaderMock = (ClassLoader)Mockito.mock(ClassLoader.class);
        Mockito.when(classLoaderMock.loadClass((String)ArgumentMatchers.any())).thenThrow(ClassNotFoundException.class);
        Future deployable = DeployableVerticle.fromClassName((Vertx)vertxMock, (String)"a wrong class name", (ClassLoader)classLoaderMock);
        Truth.assertThat((Boolean)deployable.failed()).isTrue();
        Truth.assertThat((Throwable)deployable.cause()).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    @DisplayName(value="test from class")
    void testFromClass() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        JsonObject config = new JsonObject().put("config", (Object)new JsonObject().put("foo", (Object)"bar"));
        Future deployable1 = DeployableVerticle.fromClass((Vertx)vertxMock, DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Truth.assertThat((Boolean)deployable1.succeeded()).isTrue();
        Truth.assertThat((Class)((DeployableVerticle)deployable1.result()).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Future deployable2 = DeployableVerticle.fromClass((Vertx)vertxMock, DummyVerticleHelper.DUMMY_VERTICLE.getClass(), (JsonObject)config);
        Truth.assertThat((Boolean)deployable2.succeeded()).isTrue();
        Truth.assertThat((Class)((DeployableVerticle)deployable2.result()).verticleClass).isEqualTo(DummyVerticleHelper.DUMMY_VERTICLE.getClass());
        Truth.assertThat((Iterable)((DeployableVerticle)deployable2.result()).options.getConfig()).isEqualTo((Object)config.getJsonObject("config"));
    }

    @Test
    @DisplayName(value="test from verticle")
    void testFromVerticle() {
        Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        NeonBeeMockHelper.registerNeonBeeMock(vertxMock);
        JsonObject config = new JsonObject().put("config", (Object)new JsonObject().put("foo", (Object)"bar"));
        Future deployable1 = DeployableVerticle.fromVerticle((Vertx)vertxMock, (Verticle)DummyVerticleHelper.DUMMY_VERTICLE);
        Truth.assertThat((Boolean)deployable1.succeeded()).isTrue();
        Truth.assertThat((Object)((DeployableVerticle)deployable1.result()).verticleInstance).isSameInstanceAs((Object)DummyVerticleHelper.DUMMY_VERTICLE);
        Future deployable2 = DeployableVerticle.fromVerticle((Vertx)vertxMock, (Verticle)DummyVerticleHelper.DUMMY_VERTICLE, (JsonObject)config);
        Truth.assertThat((Boolean)deployable2.succeeded()).isTrue();
        Truth.assertThat((Object)((DeployableVerticle)deployable2.result()).verticleInstance).isSameInstanceAs((Object)DummyVerticleHelper.DUMMY_VERTICLE);
        Truth.assertThat((Iterable)((DeployableVerticle)deployable2.result()).options.getConfig()).isEqualTo((Object)config.getJsonObject("config"));
    }
}

