/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.deploy;

import com.google.common.truth.Truth;
import io.neonbee.internal.deploy.DeployableTest;
import io.neonbee.internal.deploy.Deployables;
import io.neonbee.internal.deploy.PendingDeployment;
import io.vertx.core.Future;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class DeployablesTest {
    DeployablesTest() {
    }

    @Test
    @DisplayName(value="test instantiation")
    void testInstantiation() {
        Assert.assertThrows(NullPointerException.class, () -> new Deployables(null));
        Deployables deployables = new Deployables(List.of());
        Truth.assertThat((Boolean)deployables.keepPartialDeployment).isFalse();
    }

    @Test
    @DisplayName(value="test getIdentifier")
    void testGetIdentifier() {
        Truth.assertThat((String)new Deployables(List.of(new DeployableTest.DeployableThing("foo"), new DeployableTest.DeployableThing("bar"))).getIdentifier()).isEqualTo((Object)"[Thing(foo),Thing(bar)]");
        Truth.assertThat((String)new Deployables(List.of()).getIdentifier()).isEqualTo((Object)"[]");
    }

    @Test
    @DisplayName(value="test getType")
    void testGetType() {
        Truth.assertThat((String)new Deployables(List.of()).getType()).isEqualTo((Object)"Deployables");
    }

    @Test
    @DisplayName(value="test getDeployables")
    void testGetDeployables() {
        List<DeployableTest.DeployableThing> deployablesList = List.of(new DeployableTest.DeployableThing("foo"), new DeployableTest.DeployableThing("bar"));
        Deployables deployables = new Deployables(deployablesList);
        Truth.assertThat((Iterable)deployables.getDeployables()).isEqualTo(deployablesList);
        Truth.assertThat((Iterable)deployables.getDeployables()).isNotSameInstanceAs(deployablesList);
    }

    @Test
    @DisplayName(value="test getDeployables is modifiable (even if the original list was unmodifiable)")
    void testGetDeployablesIsModifiable() {
        Assertions.assertDoesNotThrow(() -> new Deployables(List.of()).getDeployables().add(new DeployableTest.DeployableThing("baz")));
    }

    @Test
    @DisplayName(value="test toString")
    void testToString() {
        Deployables deployables = new Deployables(List.of(new DeployableTest.DeployableThing("foo"), new DeployableTest.DeployableThing("bar")));
        Truth.assertThat((String)deployables.toString()).isEqualTo((Object)"Deployables([Thing(foo),Thing(bar)])");
    }

    @Test
    @DisplayName(value="test keepPartialDeployments")
    void testKeepPartialDeployments() {
        Deployables deployables = new Deployables(List.of());
        Truth.assertThat((Boolean)deployables.keepPartialDeployment).isFalse();
        Truth.assertThat((Boolean)deployables.keepPartialDeployment().keepPartialDeployment).isTrue();
        Truth.assertThat((Boolean)deployables.keepPartialDeployment).isTrue();
    }

    @Test
    @DisplayName(value="test deploy/undeploy")
    void testDeployUndeploy() {
        DeployableTest.DeployableThing deployable1 = new DeployableTest.DeployableThing("foo");
        DeployableTest.DeployableThing deployable2 = new DeployableTest.DeployableThing("bar");
        List<DeployableTest.DeployableThing> deployableThings = List.of(deployable1, deployable2);
        Deployables deployables = new Deployables(deployableThings);
        PendingDeployment deployment = deployables.deploy(null);
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((Boolean)deployable1.deploying).isTrue();
        Truth.assertThat((Boolean)deployable2.deploying).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isFalse();
        Truth.assertThat((Boolean)deployable2.undeploying).isFalse();
        Truth.assertThat((Boolean)deployment.undeploy().succeeded()).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isTrue();
        Truth.assertThat((Boolean)deployable2.undeploying).isTrue();
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployable1.deployFuture = Future.failedFuture((String)"fail");
        deployment = deployables.deploy(null);
        Truth.assertThat((Boolean)deployment.succeeded()).isFalse();
        Truth.assertThat((Boolean)deployable1.deploying).isTrue();
        Truth.assertThat((Boolean)deployable2.deploying).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isFalse();
        Truth.assertThat((Boolean)deployable2.undeploying).isTrue();
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployable2.deployFuture = Future.failedFuture((String)"fail");
        deployment = deployables.deploy(null);
        Truth.assertThat((Boolean)deployment.succeeded()).isFalse();
        Truth.assertThat((Boolean)deployable1.deploying).isTrue();
        Truth.assertThat((Boolean)deployable2.deploying).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isTrue();
        Truth.assertThat((Boolean)deployable2.undeploying).isFalse();
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployable1.undeployFuture = Future.failedFuture((String)"fail");
        deployment = deployables.deploy(null);
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((Boolean)deployable1.deploying).isTrue();
        Truth.assertThat((Boolean)deployable2.deploying).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isFalse();
        Truth.assertThat((Boolean)deployable2.undeploying).isFalse();
        Truth.assertThat((Boolean)deployment.undeploy().failed()).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isTrue();
        Truth.assertThat((Boolean)deployable2.undeploying).isTrue();
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployable1.deployFuture = Future.failedFuture((String)"deployfail");
        deployable2.undeployFuture = Future.failedFuture((String)"undeployfail");
        deployment = deployables.deploy(null);
        Truth.assertThat((Boolean)deployment.succeeded()).isFalse();
        Truth.assertThat((Boolean)deployable1.deploying).isTrue();
        Truth.assertThat((Boolean)deployable2.deploying).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isFalse();
        Truth.assertThat((Boolean)deployable2.undeploying).isTrue();
        Truth.assertThat((String)deployment.cause().getMessage()).isEqualTo((Object)"deployfail");
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployment = deployables.deploy(null, undeploymentResult -> Future.failedFuture((String)"testfailed"));
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((String)deployment.undeploy().cause().getMessage()).isEqualTo((Object)"testfailed");
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployable1.undeployFuture = Future.failedFuture((String)"undeployfailed");
        deployment = deployables.deploy(null, undeploymentResult -> Future.succeededFuture());
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((String)deployment.undeploy().cause().getMessage()).isEqualTo((Object)"undeployfailed");
        deployment = deployables.deploy(null, undeploymentResult -> Future.failedFuture((String)"testfailed"));
        Truth.assertThat((Boolean)deployment.succeeded()).isTrue();
        Truth.assertThat((String)deployment.undeploy().cause().getMessage()).isEqualTo((Object)"undeployfailed");
        deployableThings.forEach(DeployableTest.DeployableThing::reset);
        deployable1.deployFuture = Future.failedFuture((String)"fail");
        deployables.keepPartialDeployment();
        deployment = deployables.deploy(null);
        Truth.assertThat((Boolean)deployment.succeeded()).isFalse();
        Truth.assertThat((Boolean)deployable1.deploying).isTrue();
        Truth.assertThat((Boolean)deployable2.deploying).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isFalse();
        Truth.assertThat((Boolean)deployable2.undeploying).isFalse();
        Truth.assertThat((Boolean)deployment.undeploy().succeeded()).isTrue();
        Truth.assertThat((Boolean)deployable1.undeploying).isFalse();
        Truth.assertThat((Boolean)deployable2.undeploying).isTrue();
        deployables.keepPartialDeployment = false;
    }

    @Test
    @DisplayName(value="test fromDeployables")
    void testFromDeployables() {
        List<DeployableTest.DeployableThing> deployablesList = List.of(new DeployableTest.DeployableThing("foo"), new DeployableTest.DeployableThing("bar"));
        Deployables deployables = new Deployables(deployablesList);
        Truth.assertThat((Boolean)deployables.keepPartialDeployment).isFalse();
        Truth.assertThat((Iterable)((Deployables)Deployables.fromDeployables(deployablesList.stream().map(Future::succeededFuture).collect(Collectors.toList())).result()).getDeployables()).isEqualTo(deployablesList);
        Truth.assertThat((Boolean)Deployables.fromDeployables(List.of(Future.succeededFuture(), Future.failedFuture((String)"foo"))).failed()).isTrue();
    }
}

