/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import com.google.common.truth.Truth;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.internal.handler.ChainAuthHandler;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;
import io.vertx.junit5.VertxExtension;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@ExtendWith(value={VertxExtension.class})
class ChainAuthHandlerTest {
    ChainAuthHandlerTest() {
    }

    @Test
    @DisplayName(value="create empty ChainAuthHandler")
    void emptyChainAuthHandlerTest() {
        Truth.assertThat((Object)ChainAuthHandler.create(null, null)).isSameInstanceAs((Object)ChainAuthHandler.NOOP_AUTHENTICATION_HANDLER);
        Truth.assertThat((Object)ChainAuthHandler.create(null, List.of())).isSameInstanceAs((Object)ChainAuthHandler.NOOP_AUTHENTICATION_HANDLER);
    }

    @Test
    @DisplayName(value="create a non-empty ChainAuthHandler")
    void createChainAuthHandlerTest(Vertx vertx) throws IOException {
        AuthHandlerConfig config1 = (AuthHandlerConfig)Mockito.mock(AuthHandlerConfig.class);
        Mockito.when((Object)config1.createAuthHandler((Vertx)ArgumentMatchers.any())).thenReturn((Object)((AuthenticationHandler)Mockito.mock(AuthenticationHandlerInternal.class)));
        AuthHandlerConfig config2 = (AuthHandlerConfig)Mockito.mock(AuthHandlerConfig.class);
        Mockito.when((Object)config2.createAuthHandler((Vertx)ArgumentMatchers.any())).thenReturn((Object)((AuthenticationHandler)Mockito.mock(AuthenticationHandlerInternal.class)));
        ChainAuthHandler handler = ChainAuthHandler.create((Vertx)vertx, List.of(config1, config2));
        Truth.assertThat((Object)handler).isNotSameInstanceAs((Object)ChainAuthHandler.NOOP_AUTHENTICATION_HANDLER);
        ((AuthHandlerConfig)Mockito.verify((Object)config1)).createAuthHandler(vertx);
        ((AuthHandlerConfig)Mockito.verify((Object)config2)).createAuthHandler(vertx);
    }

    @Test
    @DisplayName(value="test ChainAuthHandler with multiple checks")
    void testChainAuthHandler(Vertx vertx) throws IOException {
        AtomicBoolean firstHandlerCalled = new AtomicBoolean();
        AuthenticationHandlerInternal handler1 = (AuthenticationHandlerInternal)Mockito.mock(AuthenticationHandlerInternal.class);
        AuthHandlerConfig config1 = (AuthHandlerConfig)Mockito.mock(AuthHandlerConfig.class);
        Mockito.when((Object)config1.createAuthHandler((Vertx)ArgumentMatchers.any())).thenReturn((Object)handler1);
        ((AuthenticationHandlerInternal)Mockito.doAnswer(invocation -> {
            firstHandlerCalled.set(true);
            ((Handler)invocation.getArgument(1)).handle((Object)Future.failedFuture((Throwable)new HttpException(401)));
            return null;
        }).when((Object)handler1)).authenticate((RoutingContext)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        AuthenticationHandlerInternal handler2 = (AuthenticationHandlerInternal)Mockito.mock(AuthenticationHandlerInternal.class);
        AuthHandlerConfig config2 = (AuthHandlerConfig)Mockito.mock(AuthHandlerConfig.class);
        Mockito.when((Object)config2.createAuthHandler((Vertx)ArgumentMatchers.any())).thenReturn((Object)handler2);
        RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
        HttpServerRequest requestMock = (HttpServerRequest)Mockito.mock(HttpServerRequest.class);
        Mockito.when((Object)requestMock.isEnded()).thenReturn((Object)true);
        Mockito.when((Object)routingContextMock.request()).thenReturn((Object)requestMock);
        ChainAuthHandler handler = ChainAuthHandler.create((Vertx)vertx, List.of(config1, config2));
        handler.handle((Object)routingContextMock);
        Truth.assertThat((Boolean)firstHandlerCalled.get()).isTrue();
        ((AuthenticationHandlerInternal)Mockito.verify((Object)handler2)).authenticate((RoutingContext)ArgumentMatchers.eq((Object)routingContextMock), (Handler)ArgumentMatchers.any());
    }
}

