/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import io.neonbee.config.ServerConfig;
import io.neonbee.internal.handler.CorrelationIdHandler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class CorrelationIdHandlerTest {
    CorrelationIdHandlerTest() {
    }

    @Test
    @DisplayName(value="test GENERATE_UUID correlation strategy")
    void generateUuidStrategy() {
        RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
        new CorrelationIdHandler(ServerConfig.CorrelationStrategy.GENERATE_UUID).handle(routingContextMock);
        CorrelationIdHandlerTest.verifyUuidCorrelationId(routingContextMock);
    }

    @Test
    @DisplayName(value="test REQUEST_HEADER correlation strategy fallback to UUID_STRATEGY")
    void requestHeaderStrategyFallback() {
        RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContextMock.request()).then(Mockito.RETURNS_MOCKS);
        new CorrelationIdHandler(ServerConfig.CorrelationStrategy.REQUEST_HEADER).handle(routingContextMock);
        CorrelationIdHandlerTest.verifyUuidCorrelationId(routingContextMock);
    }

    @Test
    @DisplayName(value="test REQUEST_HEADER correlation strategy x-vcap-request-id header")
    void requestHeaderStrategyHeaders() {
        String expectedCorrelationId = "expectedCorrelationId";
        for (String header : new String[]{"X-CorrelationID", "x-vcap-request-id"}) {
            RoutingContext routingContextMock = (RoutingContext)Mockito.mock(RoutingContext.class);
            HttpServerRequest requestMock = (HttpServerRequest)Mockito.mock(HttpServerRequest.class);
            Mockito.when((Object)requestMock.getHeader(header)).thenReturn((Object)expectedCorrelationId);
            Mockito.when((Object)routingContextMock.request()).thenReturn((Object)requestMock);
            new CorrelationIdHandler(ServerConfig.CorrelationStrategy.REQUEST_HEADER).handle(routingContextMock);
            CorrelationIdHandlerTest.verifyGivenCorrelationId(routingContextMock, expectedCorrelationId);
        }
    }

    private static void verifyUuidCorrelationId(RoutingContext routingContextMock) {
        CorrelationIdHandlerTest.verifyGivenCorrelationId(routingContextMock, "\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b");
    }

    private static void verifyGivenCorrelationId(RoutingContext routingContextMock, String expectedCorrelationId) {
        ((RoutingContext)Mockito.verify((Object)routingContextMock)).put((String)ArgumentMatchers.eq((Object)"correlationId"), (Object)ArgumentMatchers.matches((String)expectedCorrelationId));
    }
}

