/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.data.DataException;
import io.neonbee.hook.Hook;
import io.neonbee.hook.HookContext;
import io.neonbee.hook.HookType;
import io.neonbee.test.base.DataVerticleTestBase;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpMethod;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class HooksHandlerTest
extends DataVerticleTestBase {
    private static final String CORRELATION_ID = "bliblablub";

    HooksHandlerTest() {
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Checks that HooksHandler executes hook")
    void checkHookGetsExecutedSuccess(VertxTestContext testContext) {
        Checkpoint cp = testContext.checkpoint(2);
        TestHook hook = new TestHook();
        hook.doSomething = p -> {
            cp.flag();
            p.complete();
        };
        this.getNeonBee().getHookRegistry().registerInstanceHooks((Object)hook, CORRELATION_ID).compose(v -> this.sendRequestReturnStatusCode()).onComplete(testContext.succeeding(statusCode -> testContext.verify(() -> {
            Truth.assertThat((Integer)statusCode).isEqualTo((Object)404);
            cp.flag();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Checks that HooksHanlder executes hook and fail request in case of error")
    void checkHookGetsExecutedAndFailsRequestInCaseOfException(VertxTestContext testContext) {
        Checkpoint cp = testContext.checkpoint(2);
        TestHook hook = new TestHook();
        hook.doSomething = p -> {
            cp.flag();
            p.fail((Throwable)new Exception("Hodor"));
        };
        this.getNeonBee().getHookRegistry().registerInstanceHooks((Object)hook, CORRELATION_ID).compose(v -> this.sendRequestReturnStatusCode()).onComplete(testContext.succeeding(statusCode -> testContext.verify(() -> {
            Truth.assertThat((Integer)statusCode).isEqualTo((Object)500);
            cp.flag();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Checks that HooksHanlder executes hook and propagate error code in case of DataException")
    void checkHookGetsExecutedAndPropagateErrorCodeIfDataException(VertxTestContext testContext) {
        Checkpoint cp = testContext.checkpoint(2);
        TestHook hook = new TestHook();
        hook.doSomething = p -> {
            cp.flag();
            p.fail((Throwable)new DataException(403, "Hodor"));
        };
        this.getNeonBee().getHookRegistry().registerInstanceHooks((Object)hook, CORRELATION_ID).compose(v -> this.sendRequestReturnStatusCode()).onComplete(testContext.succeeding(statusCode -> testContext.verify(() -> {
            Truth.assertThat((Integer)statusCode).isEqualTo((Object)403);
            cp.flag();
        })));
    }

    private Future<Integer> sendRequestReturnStatusCode() {
        return this.createRequest(HttpMethod.GET, "/raw/core/Hodor").send().map(response -> response.statusCode());
    }

    public static class TestHook {
        private Consumer<Promise<Void>> doSomething = p -> {};

        @Hook(value=HookType.ONCE_PER_REQUEST)
        public void test(NeonBee neonBee, HookContext hookContext, Promise<Void> promise) {
            this.doSomething.accept(promise);
            promise.complete();
        }
    }
}

