/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.handler.factories;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.config.ServerConfig;
import io.neonbee.internal.handler.factories.SessionHandlerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.SharedData;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@ExtendWith(value={VertxExtension.class})
class SessionHandlerFactoryTest {
    SessionHandlerFactoryTest() {
    }

    @Test
    void testCreateHandlerNone(Vertx vertx, VertxTestContext testContext) {
        try (MockedStatic staticNeonBeeMock = Mockito.mockStatic(NeonBee.class);){
            NeonBee neonBeeMock = (NeonBee)Mockito.mock(NeonBee.class);
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.setSessionHandling(ServerConfig.SessionHandling.NONE);
            Mockito.when((Object)neonBeeMock.getServerConfig()).thenReturn((Object)serverConfig);
            Mockito.when((Object)neonBeeMock.getVertx()).thenReturn((Object)vertx);
            staticNeonBeeMock.when(() -> NeonBee.get()).thenReturn((Object)neonBeeMock);
            new SessionHandlerFactory().createHandler().onComplete(testContext.succeeding(instance -> testContext.verify(() -> {
                Truth.assertThat((Object)instance).isInstanceOf(SessionHandlerFactory.NoOpHandler.class);
                testContext.completeNow();
            })));
        }
    }

    @Test
    void testCreateHandlerLocal(Vertx vertx, VertxTestContext testContext) {
        try (MockedStatic staticNeonBeeMock = Mockito.mockStatic(NeonBee.class);){
            NeonBee neonBeeMock = (NeonBee)Mockito.mock(NeonBee.class);
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.setSessionHandling(ServerConfig.SessionHandling.LOCAL);
            Mockito.when((Object)neonBeeMock.getServerConfig()).thenReturn((Object)serverConfig);
            Mockito.when((Object)neonBeeMock.getVertx()).thenReturn((Object)vertx);
            staticNeonBeeMock.when(() -> NeonBee.get()).thenReturn((Object)neonBeeMock);
            new SessionHandlerFactory().createHandler().onComplete(testContext.succeeding(instance -> testContext.verify(() -> {
                Truth.assertThat((Object)instance).isInstanceOf(SessionHandler.class);
                testContext.completeNow();
            })));
        }
    }

    @Test
    void testCreateHandlerClustered(Vertx vertx, VertxTestContext testContext) {
        try (MockedStatic staticNeonBeeMock = Mockito.mockStatic(NeonBee.class);){
            NeonBee neonBeeMock = (NeonBee)Mockito.mock(NeonBee.class);
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.setSessionHandling(ServerConfig.SessionHandling.CLUSTERED);
            Mockito.when((Object)neonBeeMock.getServerConfig()).thenReturn((Object)serverConfig);
            Mockito.when((Object)neonBeeMock.getVertx()).thenReturn((Object)vertx);
            staticNeonBeeMock.when(() -> NeonBee.get()).thenReturn((Object)neonBeeMock);
            new SessionHandlerFactory().createHandler().onComplete(testContext.succeeding(instance -> testContext.verify(() -> {
                Truth.assertThat((Object)instance).isInstanceOf(SessionHandler.class);
                testContext.completeNow();
            })));
        }
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testCreateSessionStore() {
        Vertx mockedVertx = (Vertx)Mockito.mock(VertxInternal.class);
        Mockito.when((Object)mockedVertx.isClustered()).thenReturn((Object)false);
        Mockito.when((Object)mockedVertx.sharedData()).thenReturn((Object)((SharedData)Mockito.mock(SharedData.class)));
        Truth.assertThat((Boolean)SessionHandlerFactory.createSessionStore((Vertx)mockedVertx, (ServerConfig.SessionHandling)ServerConfig.SessionHandling.NONE).isEmpty()).isTrue();
        Truth.assertThat(SessionHandlerFactory.createSessionStore((Vertx)mockedVertx, (ServerConfig.SessionHandling)ServerConfig.SessionHandling.LOCAL).get()).isInstanceOf(LocalSessionStore.class);
        Truth.assertThat(SessionHandlerFactory.createSessionStore((Vertx)mockedVertx, (ServerConfig.SessionHandling)ServerConfig.SessionHandling.CLUSTERED).get()).isInstanceOf(LocalSessionStore.class);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testCreateSessionStoreClustered() {
        Vertx mockedVertx = (Vertx)Mockito.mock(VertxInternal.class);
        Mockito.when((Object)mockedVertx.isClustered()).thenReturn((Object)true);
        Mockito.when((Object)mockedVertx.sharedData()).thenReturn((Object)((SharedData)Mockito.mock(SharedData.class)));
        Truth.assertThat((Boolean)SessionHandlerFactory.createSessionStore((Vertx)mockedVertx, (ServerConfig.SessionHandling)ServerConfig.SessionHandling.NONE).isEmpty()).isTrue();
        Truth.assertThat(SessionHandlerFactory.createSessionStore((Vertx)mockedVertx, (ServerConfig.SessionHandling)ServerConfig.SessionHandling.LOCAL).get()).isInstanceOf(LocalSessionStore.class);
        Truth.assertThat(SessionHandlerFactory.createSessionStore((Vertx)mockedVertx, (ServerConfig.SessionHandling)ServerConfig.SessionHandling.CLUSTERED).get()).isInstanceOf(ClusteredSessionStore.class);
    }
}

