/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.json;

import com.google.common.truth.Truth;
import io.neonbee.internal.json.ImmutableJsonArray;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ImmutableJsonArrayTest {
    ImmutableJsonArrayTest() {
    }

    @Test
    void testImmutableClass() {
        Truth.assertThat(new ImmutableJsonArray().getList().getClass()).isEqualTo(Collections.unmodifiableList(Collections.emptyList()).getClass());
    }

    @Test
    void testEmpty() {
        Truth.assertThat((Iterable)ImmutableJsonArray.EMPTY).isEmpty();
        Truth.assertThat((Iterable)ImmutableJsonArray.EMPTY.getList()).isEmpty();
        Truth.assertThat((Iterable)new ImmutableJsonArray()).isEqualTo((Object)ImmutableJsonArray.EMPTY);
    }

    @Test
    void testImmutable() {
        ImmutableJsonArray jsonArray = new ImmutableJsonArray();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)1));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)1L));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)Float.valueOf(1.0f)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)1.0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)"String"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)new JsonObject()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)new JsonArray()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.add((Object)new byte[]{0, 1}));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.addNull());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.getList().add(true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.addAll(new JsonArray().add((Object)true)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.iterator().remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.remove(0));
    }

    @Test
    void testImmutableConstruction() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonArray().add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonArray("[]").add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonArray(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))).add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonArray(Buffer.buffer((String)"[]")).add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> new ImmutableJsonArray(new JsonArray()).add((Object)true));
    }

    @Test
    void testGetPrimitives() {
        ImmutableJsonArray jsonArray = new ImmutableJsonArray(new JsonArray().add((Object)1).add((Object)true).add((Object)"String").addNull());
        Truth.assertThat((Integer)jsonArray.getInteger(0)).isEqualTo((Object)1);
        Truth.assertThat((Boolean)jsonArray.getBoolean(1)).isEqualTo((Object)true);
        Truth.assertThat((String)jsonArray.getString(2)).isEqualTo((Object)"String");
        Truth.assertThat((Object)jsonArray.getValue(3)).isNull();
        Truth.assertThat((Boolean)jsonArray.contains((Object)"String")).isEqualTo((Object)true);
        Truth.assertThat((Boolean)jsonArray.contains((Object)false)).isEqualTo((Object)false);
        Truth.assertThat((String)jsonArray.encode()).isEqualTo((Object)"[1,true,\"String\",null]");
        Truth.assertThat((Boolean)jsonArray.isEmpty()).isEqualTo((Object)false);
        Truth.assertThat((Integer)jsonArray.size()).isEqualTo((Object)4);
    }

    @Test
    void testGetComplexValues() {
        ImmutableJsonArray jsonArray = new ImmutableJsonArray(new JsonArray().add((Object)new JsonObject().put("key1", (Object)1).put("key2", (Object)true).put("key3", (Object)"String").putNull("key4")).add((Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3)));
        Truth.assertThat((Map)jsonArray.getJsonObject(0).getMap()).containsExactly((Object)"key1", (Object)1, new Object[]{"key2", true, "key3", "String", "key4", null});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.getJsonObject(0).put("keyX", (Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((JsonObject)jsonArray.getValue(0)).put("keyX", (Object)true));
        Truth.assertThat((Iterable)jsonArray.getJsonArray(1).getList()).containsExactly(new Object[]{1, 2, 3});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> jsonArray.getJsonArray(1).add((Object)true));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((JsonArray)jsonArray.getValue(1)).add((Object)true));
    }

    @Test
    void testGetNullComplexValues() {
        ImmutableJsonArray jsonArray = new ImmutableJsonArray(new JsonArray().addNull());
        Truth.assertThat((Iterable)jsonArray.getJsonObject(0)).isNull();
        Truth.assertThat((Iterable)jsonArray.getJsonArray(0)).isNull();
        ImmutableJsonObject jsonObject = new ImmutableJsonObject(new JsonObject().putNull("baz"));
        Truth.assertThat((Iterable)jsonObject.getJsonObject("foo")).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonObject("foo", null)).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonArray("bar")).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonArray("bar", null)).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonObject("baz")).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonObject("baz", null)).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonArray("baz")).isNull();
        Truth.assertThat((Iterable)jsonObject.getJsonArray("baz", null)).isNull();
    }

    @Test
    void testMutableCopyIsMutable() {
        Assertions.assertDoesNotThrow(() -> new ImmutableJsonArray().mutableCopy().add((Object)true));
    }

    @Test
    void testCopyIsAlsoNotMutable() {
        ImmutableJsonArray array = new ImmutableJsonArray();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> array.copy().add((Object)true));
        Truth.assertThat((Iterable)array.copy()).isSameInstanceAs((Object)array);
    }

    @Test
    void testStandardMethods() {
        JsonArray array = new JsonArray().add((Object)1).add((Object)"foo").add((Object)new JsonObject());
        ImmutableJsonArray immutableArray = new ImmutableJsonArray(array);
        Truth.assertThat((String)immutableArray.toString()).isEqualTo((Object)array.toString());
        Truth.assertThat((Integer)immutableArray.hashCode()).isEqualTo((Object)array.hashCode());
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)array);
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new ImmutableJsonArray(array));
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new ImmutableJsonArray((JsonArray)immutableArray));
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new JsonArray().add((Object)1).add((Object)"foo").add((Object)new JsonObject()));
        Truth.assertThat((Iterable)immutableArray).isEqualTo((Object)new ImmutableJsonArray(new JsonArray().add((Object)1).add((Object)"foo").add((Object)new JsonObject())));
        Truth.assertThat((Iterable)immutableArray).isNotEqualTo((Object)ImmutableJsonArray.EMPTY);
    }
}

