/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.scanner;

import com.google.common.truth.Truth;
import io.neonbee.internal.BasicJar;
import io.neonbee.internal.scanner.AnnotatedClassTemplate;
import io.neonbee.internal.scanner.HookScanner;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class HookScannerTest {
    HookScannerTest() {
    }

    @Test
    @Timeout(value=5, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Should find classes which have methods that are annnotaed with @Hook or @Hooks")
    void scanForHooksTest(Vertx vertx, VertxTestContext testContext) throws IOException, URISyntaxException, ClassNotFoundException {
        BasicJar jarWithHookAnnotation = new AnnotatedClassTemplate("HodorHook", "method").setMethodAnnotation("@Hook(HookType.ONCE_PER_REQUEST)").setImports(List.of("io.neonbee.hook.Hook", "io.neonbee.hook.HookType")).asJar();
        BasicJar jarWithHooksAnnotation = new AnnotatedClassTemplate("HodorHooks", "method").setMethodAnnotation("@Hooks({ @Hook(HookType.ONCE_PER_REQUEST), @Hook(HookType.AFTER_STARTUP) })").setImports(List.of("io.neonbee.hook.Hook", "io.neonbee.hook.Hooks", "io.neonbee.hook.HookType")).asJar();
        BasicJar jarWithNoHookAnnotation = new AnnotatedClassTemplate("Hodor", "method").setMethodAnnotation("@Deprecated").asJar();
        URL[] urlc = (URL[])Stream.of(jarWithHookAnnotation.writeToTempURL(), jarWithHooksAnnotation.writeToTempURL(), jarWithNoHookAnnotation.writeToTempURL()).flatMap(Stream::of).toArray(URL[]::new);
        URLClassLoader loader = new URLClassLoader(urlc, null);
        Class<?> expectedHookClass = loader.loadClass("method.HodorHook");
        Class<?> expectedHooksClass = loader.loadClass("method.HodorHooks");
        HookScanner hs = new HookScanner((ClassLoader)loader);
        hs.scanForHooks(vertx).onComplete(testContext.succeeding(hooks -> testContext.verify(() -> {
            Truth.assertThat((Iterable)hooks).containsExactly(new Object[]{expectedHookClass, expectedHooksClass});
            testContext.completeNow();
        })));
    }
}

