/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.tracking;

import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.internal.tracking.MessageDirection;
import io.neonbee.internal.tracking.TestDeliveryContext;
import io.neonbee.internal.tracking.TestMessage;
import io.neonbee.internal.tracking.TrackingDataHandlingStrategy;
import io.neonbee.internal.tracking.TrackingInterceptor;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TrackingInterceptorTest {
    private TestMessage<Object> message;

    TrackingInterceptorTest() {
    }

    @BeforeEach
    void setUp() {
        DataContextImpl context = new DataContextImpl("correlationId", "sessionId", "bearerToken", new JsonObject().put("username", (Object)"Duke"), null, null);
        context.pushVerticleToPath("Data1Verticle");
        context.amendTopVerticleCoordinate("deplymentId1");
        context.pushVerticleToPath("Data2Verticle");
        context.amendTopVerticleCoordinate("deplymentId2");
        String dataContextJson = DataContextImpl.encodeContextToString((DataContext)context);
        this.message = new TestMessage<DataQuery>("address", "replyAddress", MultiMap.caseInsensitiveMultiMap().add("Context", dataContextJson), new DataQuery());
    }

    @Test
    @DisplayName(value="test outbound message")
    void testHandleOutBoundMessages() {
        TrackingDataHandlingStrategy strategy = (TrackingDataHandlingStrategy)Mockito.mock(TrackingDataHandlingStrategy.class);
        TrackingInterceptor interceptor = new TrackingInterceptor(MessageDirection.OUTBOUND, strategy);
        ((TrackingDataHandlingStrategy)Mockito.doNothing().when((Object)strategy)).handleOutBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.doNothing().when((Object)strategy)).handleOutBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        TestDeliveryContext<Object> deliveryContext = new TestDeliveryContext<Object>(this.message);
        interceptor.handle(deliveryContext);
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)1))).handleOutBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)0))).handleOutBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        Mockito.reset((Object[])new TrackingDataHandlingStrategy[]{strategy});
        this.message.setReplyAddress(null);
        interceptor.handle(deliveryContext);
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)0))).handleOutBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)1))).handleOutBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        Mockito.reset((Object[])new TrackingDataHandlingStrategy[]{strategy});
    }

    @Test
    @DisplayName(value="test inbound message")
    void testHandleInBoundMessages() {
        TrackingDataHandlingStrategy strategy = (TrackingDataHandlingStrategy)Mockito.mock(TrackingDataHandlingStrategy.class);
        TrackingInterceptor interceptor = new TrackingInterceptor(MessageDirection.INBOUND, strategy);
        ((TrackingDataHandlingStrategy)Mockito.doNothing().when((Object)strategy)).handleInBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.doNothing().when((Object)strategy)).handleInBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        TestDeliveryContext<Object> deliveryContext = new TestDeliveryContext<Object>(this.message);
        interceptor.handle(deliveryContext);
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)1))).handleInBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)0))).handleInBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        Mockito.reset((Object[])new TrackingDataHandlingStrategy[]{strategy});
        this.message.setReplyAddress(null);
        interceptor.handle(deliveryContext);
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)0))).handleInBoundRequest((DataContext)ArgumentMatchers.any(DataContext.class));
        ((TrackingDataHandlingStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.times((int)1))).handleInBoundReply((DataContext)ArgumentMatchers.any(DataContext.class));
        Mockito.reset((Object[])new TrackingDataHandlingStrategy[]{strategy});
    }
}

