/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import ch.qos.logback.classic.Level;
import com.google.common.truth.Truth;
import io.neonbee.internal.verticle.LoggerConfiguration;
import io.neonbee.logging.LoggingFacade;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LoggerConfigurationTest {
    public static final LoggerConfiguration ROOT = new LoggerConfiguration("ROOT", Level.INFO);
    private static int logInstanceCount;
    private final LoggerConfiguration logger1 = new LoggerConfiguration(null, Level.WARN);
    private final LoggerConfiguration logger2 = new LoggerConfiguration(null, Level.DEBUG);

    LoggerConfigurationTest() {
    }

    @BeforeEach
    void setUpLoggers() {
        String name1 = LoggerConfigurationTest.class.getSimpleName() + ++logInstanceCount;
        LoggingFacade.create((String)name1);
        this.logger1.setName(name1);
        String name2 = LoggerConfigurationTest.class.getSimpleName() + ++logInstanceCount;
        LoggingFacade.create((String)name2);
        this.logger2.setName(name2);
    }

    @Test
    void testBasics() {
        Truth.assertThat((Integer)ROOT.hashCode()).isNotEqualTo((Object)0);
        Truth.assertThat((String)ROOT.toString()).isEqualTo((Object)"LoggerConfiguration [name=ROOT, configuredLevel=INFO]");
        Truth.assertThat((String)ROOT.getName()).isEqualTo((Object)"ROOT");
        Truth.assertThat((Object)ROOT.getConfiguredLevel()).isEqualTo((Object)Level.INFO);
    }

    @Test
    void testToJson() {
        JsonObject json = ROOT.toJson();
        Truth.assertThat((Iterable)json).isEqualTo((Object)new JsonObject().put("name", (Object)"ROOT").put("configuredLevel", (Object)"INFO"));
    }

    @Test
    void testFromJson() {
        JsonObject json = new JsonObject().put("name", (Object)"logger1").put("configuredLevel", (Object)Level.ERROR.levelStr);
        LoggerConfiguration configuration = LoggerConfiguration.fromJson((JsonObject)json);
        Truth.assertThat((Comparable)configuration).isEqualTo((Object)new LoggerConfiguration("logger1", Level.ERROR));
    }

    @Test
    void testCompare() {
        Truth.assertThat((Integer)ROOT.compareTo(this.logger1)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)this.logger2.compareTo(this.logger1)).isEqualTo((Object)1);
    }

    @Test
    void testCopy() {
        Truth.assertThat((Comparable)ROOT.copy()).isEqualTo((Object)ROOT);
        Truth.assertThat((Comparable)ROOT.copy()).isNotSameInstanceAs((Object)ROOT);
    }

    @Test
    void testToAndFromJson() {
        Truth.assertThat((Comparable)LoggerConfiguration.fromJson((JsonObject)this.logger1.toJson())).isEqualTo((Object)this.logger1);
    }

    @Test
    void testApplyingEffectiveLogLevels() {
        this.logger1.setEffectiveLevel(Level.INFO);
        Truth.assertThat((Object)this.logger1.getEffectiveLevel()).isEqualTo((Object)Level.INFO);
        this.logger1.setEffectiveLevel("warn");
        Truth.assertThat((Object)this.logger1.getEffectiveLevel()).isEqualTo((Object)Level.WARN);
        Arrays.stream(new Level[]{Level.DEBUG, Level.ERROR, Level.WARN}).forEach(level -> {
            this.logger1.setEffectiveLevel(level);
            Truth.assertThat((Object)this.logger1.getEffectiveLevel()).isEqualTo(level);
            Truth.assertThat((Object)this.logger1.setEffectiveLevel(Level.INFO).setConfiguredLevel(level).applyConfiguredLevel().getEffectiveLevel()).isEqualTo(level);
        });
        this.logger1.setEffectiveLevel(Level.TRACE);
        this.logger1.setConfiguredLevel((Level)null);
        this.logger1.applyConfiguredLevel();
        Truth.assertThat((Object)this.logger1.getEffectiveLevel()).isNotEqualTo((Object)Level.TRACE);
    }
}

