/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.internal.verticle;

import com.google.common.truth.Truth;
import io.neonbee.internal.handler.DefaultErrorHandler;
import io.neonbee.internal.handler.factories.RoutingHandlerFactory;
import io.neonbee.internal.verticle.ServerVerticle;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class ServerVerticleTest
extends NeonBeeTestBase {
    ServerVerticleTest() {
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testMaximumInitialLineAndCookieSizes(VertxTestContext testCtx) {
        Checkpoint checkpoint = testCtx.checkpoint(4);
        this.createRequest(HttpMethod.GET, "/any404").putHeader("smallHeader", "x").send(testCtx.succeeding(response -> testCtx.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)404);
            checkpoint.flag();
        })));
        this.createRequest(HttpMethod.GET, "/" + "x".repeat(4081)).send(testCtx.succeeding(response -> testCtx.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)404);
            checkpoint.flag();
        })));
        this.createRequest(HttpMethod.GET, "/" + "x".repeat(4083)).send(testCtx.succeeding(response -> testCtx.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)414);
            checkpoint.flag();
        })));
        this.createRequest(HttpMethod.GET, "/any404").putHeader("largeHeader", "x".repeat(10000)).send(testCtx.succeeding(response -> testCtx.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)431);
            checkpoint.flag();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testLargerMaximumInitialLineAndCookieSizesConfig(VertxTestContext testCtx) {
        Checkpoint checkpoint = testCtx.checkpoint(2);
        this.createRequest(HttpMethod.GET, "/" + "x".repeat(4083)).send(testCtx.succeeding(response -> testCtx.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)404);
            checkpoint.flag();
        })));
        this.createRequest(HttpMethod.GET, "/any404").putHeader("largeHeader", "x".repeat(10000)).send(testCtx.succeeding(response -> testCtx.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)404);
            checkpoint.flag();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testGetErrorHandlerDefault(Vertx vertx, VertxTestContext testCtx) throws Exception {
        Checkpoint cp = testCtx.checkpoint(2);
        ServerVerticle.createErrorHandler(null, (Vertx)vertx).onComplete(testCtx.succeeding(clazz -> testCtx.verify(() -> {
            Truth.assertThat((Object)clazz).isInstanceOf(DefaultErrorHandler.class);
            cp.flag();
        })));
        ServerVerticle.createErrorHandler((String)"Hugo", (Vertx)vertx).onComplete(testCtx.failing(t -> testCtx.verify(() -> {
            Truth.assertThat((Throwable)t).isInstanceOf(ClassNotFoundException.class);
            Truth.assertThat((Throwable)t).hasMessageThat().contains((CharSequence)"Hugo");
            cp.flag();
        })));
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        if ("testLargerMaximumInitialLineAndCookieSizesConfig".equals(testInfo.getTestMethod().map(Method::getName).orElse(null))) {
            return WorkingDirectoryBuilder.standard().setCustomTask(root -> {
                Path serverVerticleConfigPath = root.resolve(WorkingDirectoryBuilder.CONFIG_DIR).resolve(ServerVerticle.class.getName() + ".json");
                JsonObject config = new JsonObject().put("config", (Object)new JsonObject().put("maxHeaderSize", (Object)32768).put("maxInitialLineLength", (Object)8192));
                testContext.verify(() -> {
                    Buffer oldConfig = Buffer.buffer((byte[])Files.readAllBytes(serverVerticleConfigPath));
                    Buffer newConfig = oldConfig.toJsonObject().mergeIn(config, true).toBuffer();
                    Files.write(serverVerticleConfigPath, newConfig.getBytes(), new OpenOption[0]);
                });
            });
        }
        return super.provideWorkingDirectoryBuilder(testInfo, testContext);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testInstantiateHandler(VertxTestContext testContext) {
        ServerVerticle.instantiateHandler((String)TestRoutingHandlerFactory.class.getName()).onComplete(testContext.succeeding(clazz -> testContext.verify(() -> {
            Truth.assertThat((Object)clazz).isInstanceOf(Handler.class);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testFailingInstantiateHandler(VertxTestContext testContext) {
        ServerVerticle.instantiateHandler((String)TestFailingRoutingHandlerFactory.class.getName()).onComplete(testContext.failing(throwable -> testContext.verify(() -> {
            Truth.assertThat((Throwable)throwable).hasMessageThat().isEqualTo((Object)"test failing createHandler.");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testExptionInstantiateHandler(VertxTestContext testContext) {
        ServerVerticle.instantiateHandler((String)TestThrowingRoutingHandlerFactory.class.getName()).onComplete(testContext.failing(throwable -> testContext.verify(() -> {
            Truth.assertThat((Throwable)throwable).isInstanceOf(IllegalStateException.class);
            Truth.assertThat((Throwable)throwable).hasMessageThat().isEqualTo((Object)"Test exception thrown in createHandler.");
            testContext.completeNow();
        })));
    }

    public static class TestRoutingHandlerFactory
    implements RoutingHandlerFactory {
        public Future<Handler<RoutingContext>> createHandler() {
            return Future.succeededFuture(event -> {});
        }
    }

    public static class TestFailingRoutingHandlerFactory
    implements RoutingHandlerFactory {
        public static final String EXCEPTION_MESSAGE = "test failing createHandler.";

        public Future<Handler<RoutingContext>> createHandler() {
            return Future.failedFuture((String)EXCEPTION_MESSAGE);
        }
    }

    public static class TestThrowingRoutingHandlerFactory
    implements RoutingHandlerFactory {
        public static final String EXCEPTION_MESSAGE = "Test exception thrown in createHandler.";

        public Future<Handler<RoutingContext>> createHandler() {
            throw new IllegalStateException(EXCEPTION_MESSAGE);
        }
    }
}

