/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.job;

import com.google.common.truth.Truth;
import io.neonbee.job.JobSchedule;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class JobScheduleTest {
    JobScheduleTest() {
    }

    @Test
    @DisplayName(value="Initialize JobSchedule")
    void testJobSchedule() {
        Instant now = Instant.now();
        JobSchedule schedule = new JobSchedule();
        Truth.assertThat((Comparable)schedule.getStart()).isNull();
        Truth.assertThat((Comparable)schedule.getEnd()).isNull();
        Truth.assertThat((Boolean)schedule.isPeriodic()).isFalse();
        Truth.assertThat((Object)schedule.getAdjuster()).isNull();
        schedule = new JobSchedule(now);
        Truth.assertThat((Comparable)schedule.getStart()).isEqualTo((Object)now);
        Truth.assertThat((Comparable)schedule.getEnd()).isNull();
        Truth.assertThat((Boolean)schedule.isPeriodic()).isFalse();
        Truth.assertThat((Object)schedule.getAdjuster()).isNull();
        schedule = new JobSchedule(Duration.ofHours(1L));
        Truth.assertThat((Comparable)schedule.getStart()).isNull();
        Truth.assertThat((Comparable)schedule.getEnd()).isNull();
        Truth.assertThat((Boolean)schedule.isPeriodic()).isTrue();
        Truth.assertThat((Long)now.until(schedule.adjustInto((Temporal)now), ChronoUnit.MINUTES)).isEqualTo((Object)60);
        schedule = new JobSchedule(now, Duration.ofMinutes(1337L), now);
        Truth.assertThat((Comparable)schedule.getStart()).isEqualTo((Object)now);
        Truth.assertThat((Comparable)schedule.getEnd()).isEqualTo((Object)now);
        Truth.assertThat((Boolean)schedule.isPeriodic()).isTrue();
        Truth.assertThat((Long)now.until(schedule.adjustInto((Temporal)now), ChronoUnit.MINUTES)).isEqualTo((Object)1337);
        schedule = new JobSchedule(now, temporal -> temporal.plus(20L, ChronoUnit.SECONDS), now);
        Truth.assertThat((Long)now.until(schedule.adjustInto((Temporal)now), ChronoUnit.SECONDS)).isEqualTo((Object)20);
    }
}

