/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.job;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.data.DataContext;
import io.neonbee.job.JobSchedule;
import io.neonbee.job.JobVerticle;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.OptionsHelper;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class JobVerticleTest
extends NeonBeeTestBase {
    JobVerticleTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
        options.setDisableJobScheduling(false);
    }

    @Test
    @DisplayName(value="Verify that jobs are scheduled at the expected times")
    void verifyJobSchedule() {
        TestJobVerticle testJobVerticle = new TestJobVerticle(new JobSchedule());
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).setTimer(ArgumentMatchers.longThat(JobVerticleTest.isApproximately(100L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().minus(30L, ChronoUnit.SECONDS)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.never())).setTimer(AdditionalMatchers.not((long)ArgumentMatchers.eq((long)50L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().plus(30L, ChronoUnit.SECONDS)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).setTimer(ArgumentMatchers.longThat(JobVerticleTest.isApproximately(30000L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().minus(30L, ChronoUnit.SECONDS), Duration.ofMinutes(1L)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).setTimer(ArgumentMatchers.longThat(JobVerticleTest.isApproximately(30000L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().minus(90L, ChronoUnit.SECONDS), Duration.ofMinutes(1L)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).setTimer(ArgumentMatchers.longThat(JobVerticleTest.isApproximately(30000L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().plus(30L, ChronoUnit.SECONDS), Duration.ofMinutes(100L)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).setTimer(ArgumentMatchers.longThat(JobVerticleTest.isApproximately(30000L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Duration.ofMinutes(100L), Instant.now().plus(30L, ChronoUnit.SECONDS)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).setTimer(AdditionalMatchers.not((long)ArgumentMatchers.eq((long)50L)), (Handler)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Duration.ofMinutes(100L), Instant.now().minus(30L, ChronoUnit.SECONDS)), false, 1);
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.times((int)1))).setTimer(ArgumentMatchers.eq((long)50L), (Handler)ArgumentMatchers.any());
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).undeploy("expected_deployment_id");
        testJobVerticle = new TestJobVerticle(new JobSchedule(Duration.ofMinutes(100L), Instant.now().minus(30L, ChronoUnit.SECONDS)), false);
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.never())).setTimer(AdditionalMatchers.not((long)ArgumentMatchers.eq((long)50L)), (Handler)ArgumentMatchers.any());
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.never())).undeploy((String)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().minus(30L, ChronoUnit.SECONDS), Duration.ofMinutes(1L), Instant.now().plus(10L, ChronoUnit.SECONDS)));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.never())).setTimer(AdditionalMatchers.not((long)ArgumentMatchers.eq((long)50L)), (Handler)ArgumentMatchers.any());
    }

    @Test
    @DisplayName(value="Verify that jobs executed when scheduled")
    void verifyJobExecuted() {
        TestJobVerticle testJobVerticle = new TestJobVerticle(new JobSchedule(), false, 100);
        Truth.assertThat((Integer)testJobVerticle.jobExecuted).isEqualTo((Object)1);
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).undeploy((String)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Duration.ofMinutes(1L)), false, 100);
        Truth.assertThat((Integer)testJobVerticle.jobExecuted).isEqualTo((Object)100);
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.never())).undeploy((String)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Instant.now().plus(30L, ChronoUnit.MINUTES), Duration.ofMinutes(1L)), false, 100);
        Truth.assertThat((Integer)testJobVerticle.jobExecuted).isEqualTo((Object)100);
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock, (VerificationMode)Mockito.never())).undeploy((String)ArgumentMatchers.any());
        testJobVerticle = new TestJobVerticle(new JobSchedule(Duration.ofMillis(100L), Instant.now().plus(2L, ChronoUnit.SECONDS).plus(95L, ChronoUnit.MILLIS)), true, 100);
        Truth.assertThat((Integer)testJobVerticle.jobExecuted).isAtLeast((Comparable)Integer.valueOf(17));
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).undeploy((String)ArgumentMatchers.any());
    }

    @Test
    @DisplayName(value="Verify that jobs are disabled when flag is set")
    void verifyDisableJobScheduling() {
        TestJobVerticle testJobVerticle = new TestJobVerticle(new JobSchedule(), false, 1, true, true);
        Truth.assertThat((Integer)testJobVerticle.jobExecuted).isEqualTo((Object)0);
        ((Vertx)Mockito.verify((Object)testJobVerticle.vertxMock)).undeploy((String)ArgumentMatchers.any());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Do not start JobVerticles with invalid JobSchedule")
    void testStartFailing(VertxTestContext testConetxt) {
        class DummyJobVerticle
        extends JobVerticle {
            DummyJobVerticle(JobSchedule schedule) {
                super(schedule);
            }

            public Future<?> execute(DataContext context) {
                return Future.succeededFuture();
            }
        }
        DummyJobVerticle dummyJobVerticle = new DummyJobVerticle(new JobSchedule(Duration.ofMinutes(0L)));
        this.deployVerticle((Verticle)dummyJobVerticle).onComplete(testConetxt.failing(t -> {
            testConetxt.verify(() -> Truth.assertThat((Throwable)t).hasMessageThat().isEqualTo((Object)"The period of a periodic JobSchedule can't be zero"));
            testConetxt.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Do start JobVerticles with a valid JobSchedule")
    void testStartSucceeding(VertxTestContext testConetxt) {
        final Checkpoint cp = testConetxt.checkpoint();
        class DummyJobVerticle
        extends JobVerticle {
            DummyJobVerticle(JobSchedule schedule) {
                super(schedule);
            }

            public Future<?> execute(DataContext context) {
                cp.flag();
                return Future.succeededFuture();
            }
        }
        DummyJobVerticle dummyJobVerticle = new DummyJobVerticle(new JobSchedule(Duration.ofMinutes(1L)));
        this.deployVerticle((Verticle)dummyJobVerticle).onComplete(testConetxt.succeeding(v -> {}));
    }

    private static ArgumentMatcher<Long> isApproximately(long expectedDelay) {
        return delay -> delay <= expectedDelay && delay >= expectedDelay - 100L;
    }

    private static class TestJobVerticle
    extends JobVerticle {
        public final Vertx vertxMock = NeonBeeMockHelper.defaultVertxMock();
        public int jobExecuted;

        TestJobVerticle(JobSchedule schedule) {
            this(schedule, true);
        }

        TestJobVerticle(JobSchedule schedule, boolean undeployWhenDone) {
            this(schedule, undeployWhenDone, false);
        }

        TestJobVerticle(JobSchedule schedule, boolean undeployWhenDone, boolean disableJobScheduling) {
            this(schedule, false, 0, undeployWhenDone, disableJobScheduling);
        }

        TestJobVerticle(JobSchedule schedule, boolean delayExecutions, int breakExecutionsAfter) {
            this(schedule, delayExecutions, breakExecutionsAfter, true);
        }

        TestJobVerticle(JobSchedule schedule, boolean delayExecutions, int breakExecutionsAfter, boolean undeployWhenDone) {
            this(schedule, delayExecutions, breakExecutionsAfter, undeployWhenDone, false);
        }

        TestJobVerticle(JobSchedule schedule, boolean delayExecutions, int breakExecutionsAfter, boolean undeployWhenDone, boolean disableJobScheduling) {
            super(schedule, undeployWhenDone);
            NeonBeeMockHelper.registerNeonBeeMock(this.vertxMock, (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles().setDisableJobScheduling(disableJobScheduling));
            ((Vertx)Mockito.doAnswer(invocation -> {
                if (delayExecutions) {
                    TimeUnit.MILLISECONDS.sleep((Long)invocation.getArgument(0));
                }
                if (this.jobExecuted < breakExecutionsAfter) {
                    ((Handler)invocation.getArgument(1)).handle((Object)1337L);
                }
                return null;
            }).when((Object)this.vertxMock)).setTimer(ArgumentMatchers.anyLong(), (Handler)ArgumentMatchers.any());
            this.start();
        }

        public Vertx getVertx() {
            return this.vertxMock;
        }

        public Future<?> execute(DataContext context) {
            ++this.jobExecuted;
            return Future.succeededFuture();
        }

        public String deploymentID() {
            return "expected_deployment_id";
        }
    }
}

