/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.logging.internal;

import com.google.common.truth.Truth;
import io.neonbee.logging.internal.LoggingFacadeImpl;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.Marker;

class LoggingFacadeImplTest {
    private static final String DUMMY_LOG_MSG = "HODOR {}";
    private static final Object DUMMY_ARGUMENT = new Object();
    private static final Throwable DUMMY_THROWABLE = new Exception("Exception");
    private static final Object[] DUMMY_ARGUMENTS = new Object[]{DUMMY_ARGUMENT, DUMMY_THROWABLE};
    private final Logger mockedLogger = (Logger)Mockito.mock(Logger.class);
    private LoggingFacadeImpl facade;

    LoggingFacadeImplTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.reset((Object[])new Logger[]{this.mockedLogger});
        this.facade = new LoggingFacadeImpl(this.mockedLogger);
    }

    @Test
    void testCorrelateWith() {
        String correlId = "hodor";
        LoggingFacadeImpl facade = new LoggingFacadeImpl(null);
        facade.correlateWith(correlId);
        Marker hodorMarker = facade.currentMarker;
        Truth.assertThat((String)hodorMarker.getName()).isEqualTo((Object)correlId);
        facade.correlateWith(correlId);
        Truth.assertThat((Object)facade.currentMarker).isSameInstanceAs((Object)hodorMarker);
        facade.correlateWith("");
        Truth.assertThat((Object)facade.currentMarker).isEqualTo((Object)LoggingFacadeImpl.DEFAULT_MARKER);
        facade.correlateWith((String)null);
        Truth.assertThat((Object)facade.currentMarker).isEqualTo((Object)LoggingFacadeImpl.DEFAULT_MARKER);
    }

    @Test
    void testGetName() {
        this.facade.getName();
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).getName();
    }

    @Test
    void testTrace() {
        this.facade.isTraceEnabled();
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).isTraceEnabled(LoggingFacadeImpl.DEFAULT_MARKER);
        this.facade.trace(DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).trace(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        this.facade.trace(DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).trace(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        this.facade.trace(DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).trace(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        this.facade.trace(DUMMY_LOG_MSG, DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).trace(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_THROWABLE);
        Mockito.reset((Object[])new Logger[]{this.mockedLogger});
        this.facade.correlateWith("anyid").trace(DUMMY_LOG_MSG);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).trace((Marker)ArgumentMatchers.argThat(marker -> "anyid".equals(marker.toString())), (String)ArgumentMatchers.eq((Object)DUMMY_LOG_MSG));
    }

    @Test
    void testDebug() {
        this.facade.isDebugEnabled();
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).isDebugEnabled(LoggingFacadeImpl.DEFAULT_MARKER);
        this.facade.debug(DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).debug(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        this.facade.debug(DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).debug(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        this.facade.debug(DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).debug(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        this.facade.debug(DUMMY_LOG_MSG, DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).debug(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_THROWABLE);
        Mockito.reset((Object[])new Logger[]{this.mockedLogger});
        this.facade.correlateWith("anyid").debug(DUMMY_LOG_MSG);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).debug((Marker)ArgumentMatchers.argThat(marker -> "anyid".equals(marker.toString())), (String)ArgumentMatchers.eq((Object)DUMMY_LOG_MSG));
    }

    @Test
    void testInfo() {
        this.facade.isInfoEnabled();
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).isInfoEnabled(LoggingFacadeImpl.DEFAULT_MARKER);
        this.facade.info(DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).info(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        this.facade.info(DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).info(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        this.facade.info(DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).info(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        this.facade.info(DUMMY_LOG_MSG, DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).info(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_THROWABLE);
        Mockito.reset((Object[])new Logger[]{this.mockedLogger});
        this.facade.correlateWith("anyid").info(DUMMY_LOG_MSG);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).info((Marker)ArgumentMatchers.argThat(marker -> "anyid".equals(marker.toString())), (String)ArgumentMatchers.eq((Object)DUMMY_LOG_MSG));
    }

    @Test
    void testWarn() {
        this.facade.isWarnEnabled();
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).isWarnEnabled(LoggingFacadeImpl.DEFAULT_MARKER);
        this.facade.warn(DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).warn(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        this.facade.warn(DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).warn(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        this.facade.warn(DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).warn(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        this.facade.warn(DUMMY_LOG_MSG, DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).warn(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_THROWABLE);
        Mockito.reset((Object[])new Logger[]{this.mockedLogger});
        this.facade.correlateWith("anyid").warn(DUMMY_LOG_MSG);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).warn((Marker)ArgumentMatchers.argThat(marker -> "anyid".equals(marker.toString())), (String)ArgumentMatchers.eq((Object)DUMMY_LOG_MSG));
    }

    @Test
    void testError() {
        this.facade.isErrorEnabled();
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).isErrorEnabled(LoggingFacadeImpl.DEFAULT_MARKER);
        this.facade.error(DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).error(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENTS);
        this.facade.error(DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).error(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT);
        this.facade.error(DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).error(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_ARGUMENT, (Object)DUMMY_THROWABLE);
        this.facade.error(DUMMY_LOG_MSG, DUMMY_THROWABLE);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).error(LoggingFacadeImpl.DEFAULT_MARKER, DUMMY_LOG_MSG, DUMMY_THROWABLE);
        Mockito.reset((Object[])new Logger[]{this.mockedLogger});
        this.facade.correlateWith("anyid").error(DUMMY_LOG_MSG);
        ((Logger)Mockito.verify((Object)this.mockedLogger, (VerificationMode)Mockito.times((int)1))).error((Marker)ArgumentMatchers.argThat(marker -> "anyid".equals(marker.toString())), (String)ArgumentMatchers.eq((Object)DUMMY_LOG_MSG));
    }

    @Test
    void testUnsupportedOperations() {
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.isTraceEnabled(LoggingFacadeImpl.DEFAULT_MARKER));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.isDebugEnabled(LoggingFacadeImpl.DEFAULT_MARKER));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.isInfoEnabled(LoggingFacadeImpl.DEFAULT_MARKER));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.isWarnEnabled(LoggingFacadeImpl.DEFAULT_MARKER));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.isErrorEnabled(LoggingFacadeImpl.DEFAULT_MARKER));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.info(LoggingFacadeImpl.DEFAULT_MARKER, "test"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.error(LoggingFacadeImpl.DEFAULT_MARKER, "test"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.warn(LoggingFacadeImpl.DEFAULT_MARKER, "test"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.debug(LoggingFacadeImpl.DEFAULT_MARKER, "test"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.trace(LoggingFacadeImpl.DEFAULT_MARKER, "test"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.info(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {}", (Object)"test2"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.error(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {}", (Object)"test2"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.warn(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {}", (Object)"test2"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.debug(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {}", (Object)"test2"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.trace(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {}", (Object)"test2"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.info(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {}", (Object)"test2", (Object)"test3"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.error(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {}", (Object)"test2", (Object)"test3"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.warn(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {}", (Object)"test2", (Object)"test3"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.debug(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {}", (Object)"test2", (Object)"test3"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.trace(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {}", (Object)"test2", (Object)"test3"));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.info(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {} {}", new Object[]{"test2", "test3", "test4"}));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.error(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {} {}", new Object[]{"test2", "test3", "test4"}));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.warn(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {} {}", new Object[]{"test2", "test3", "test4"}));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.debug(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {} {}", new Object[]{"test2", "test3", "test4"}));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.trace(LoggingFacadeImpl.DEFAULT_MARKER, "test1 {} {} {}", new Object[]{"test2", "test3", "test4"}));
        Exception anyException = new Exception();
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.info(LoggingFacadeImpl.DEFAULT_MARKER, "test1", (Throwable)anyException));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.error(LoggingFacadeImpl.DEFAULT_MARKER, "test1", (Throwable)anyException));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.warn(LoggingFacadeImpl.DEFAULT_MARKER, "test1", (Throwable)anyException));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.debug(LoggingFacadeImpl.DEFAULT_MARKER, "test1", (Throwable)anyException));
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.facade.trace(LoggingFacadeImpl.DEFAULT_MARKER, "test1", (Throwable)anyException));
    }
}

