/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.base;

import com.google.common.truth.Truth;
import io.neonbee.test.base.ODataRequest;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ODataRequestTest {
    private final Map<String, Object> compositeMap = new HashMap<String, Object>();
    private static final String EXPECTED_SERVICE_ROOT_URL = "my-namespace";
    private ODataRequest odataRequest;

    ODataRequestTest() {
    }

    @BeforeEach
    @DisplayName(value="Setup the base OData request")
    void setUp() {
        FullQualifiedName fqn = new FullQualifiedName(EXPECTED_SERVICE_ROOT_URL, "my-entity");
        this.odataRequest = new ODataRequest(fqn);
        this.compositeMap.clear();
    }

    @Test
    @DisplayName(value="with $metadata set")
    void testGetUriWithMetadata() {
        this.odataRequest.setMetadata();
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/$metadata");
        this.odataRequest.setMetadata().setKey(1L).setProperty("ignore");
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/$metadata");
    }

    @Test
    @DisplayName(value="with $count set")
    void testGetUriWithCount() {
        this.odataRequest.setCount();
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity/$count");
        this.odataRequest.setCount().setKey(1L).setProperty("ignore");
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity/$count");
    }

    @Test
    @DisplayName(value="with namespace and entity name")
    void testGetUriNamespace() {
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity");
    }

    @Test
    @DisplayName(value="with single string key")
    void testGetUriSingleStringKey() {
        this.odataRequest.setKey("0123");
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity('0123')");
    }

    @Test
    @DisplayName(value="with single long key")
    void testGetUriSingleLongKey() {
        this.odataRequest.setKey(1234L);
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity(1234)");
    }

    @Test
    @DisplayName(value="with single date key")
    void testGetUriSingleDateKey() {
        this.odataRequest.setKey(LocalDate.of(2020, 2, 22));
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity(2020-02-22)");
    }

    @Test
    @DisplayName(value="with multiple valid keys")
    void testGetUriMultipleValidKeys() {
        this.compositeMap.put("ID", 123L);
        this.compositeMap.put("Name", "cheese");
        this.compositeMap.put("Description", "something");
        this.compositeMap.put("date", LocalDate.parse("2020-02-22").atStartOfDay().toLocalDate());
        this.odataRequest.setKey(this.compositeMap);
        String uri = this.odataRequest.getUri();
        Truth.assertThat((String)uri).containsMatch("^my-namespace/my-entity\\(.*\\)$");
        Truth.assertThat((String)uri).containsMatch("Description='something'");
        Truth.assertThat((String)uri).containsMatch("Name='cheese'");
        Truth.assertThat((String)uri).containsMatch("ID=123");
        Truth.assertThat((String)uri).containsMatch("date=2020-02-22");
    }

    @Test
    @DisplayName(value="with multiple invalid keys")
    void testGetUriMultipleInvalidKeys() {
        this.compositeMap.put("ID", 123L);
        this.compositeMap.put("", "cheese");
        this.odataRequest.setKey(this.compositeMap);
        try {
            this.odataRequest.getUri();
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
            Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"For multi-part keys the full key predicate is required.");
        }
    }

    @Test
    @DisplayName(value="with wrong type")
    void testGetUriWrongType() {
        this.compositeMap.put("ID", Character.valueOf('1'));
        try {
            this.odataRequest.setKey(this.compositeMap);
        }
        catch (Exception e) {
            Truth.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
            Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Expecting either type String or Long as key, but received java.lang.Character");
        }
    }

    @Test
    @DisplayName(value="with multiple invocations of setKey")
    void testGetUriMultipleInvocationsOfSetKey() {
        this.compositeMap.put("ID", 123L);
        this.odataRequest.setKey(this.compositeMap).setKey(123L).setKey("surprise");
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity('surprise')");
    }

    @Test
    @DisplayName(value="with property set")
    void testGetUriWithProperty() {
        this.odataRequest.setProperty("my-property");
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity/my-property");
    }

    @Test
    @DisplayName(value="with expand single attribute")
    void testExpand() {
        this.odataRequest.setKey("0123").setExpandQuery("ExpandItem");
        Truth.assertThat((String)this.odataRequest.getUri()).isEqualTo((Object)"my-namespace/my-entity('0123')?$expand=ExpandItem");
    }
}

