/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import com.google.common.truth.Truth;
import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.TestService1EntityVerticle;
import io.vertx.core.Verticle;
import io.vertx.core.http.HttpMethod;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ODataDeleteEntityTest
extends ODataEndpointTestBase {
    private ODataRequest oDataRequest;

    ODataDeleteEntityTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(TestService1EntityVerticle.getDeclaredEntityModel());
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        this.deployVerticle((Verticle)new TestService1EntityVerticle()).onComplete(testContext.succeedingThenComplete());
        this.oDataRequest = new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN).setMethod(HttpMethod.DELETE);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 405 METHOD NOT ALLOWED if the request was sent to the entity set url instead of a dedicated entity")
    void deleteEntitySetTest(VertxTestContext testContext) {
        this.requestOData(this.oDataRequest).onComplete(testContext.succeeding(response -> {
            testContext.verify(() -> Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)405));
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 204 NO CONTENT if an entity was successfully deleted ")
    void deleteEntityTest(VertxTestContext testContext) {
        this.oDataRequest.setKey("id-5");
        this.requestOData(this.oDataRequest).onComplete(testContext.succeeding(response -> {
            testContext.verify(() -> Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)204));
            testContext.completeNow();
        }));
    }
}

