/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.NavPropsCategoriesEntityVerticle;
import io.neonbee.test.endpoint.odata.verticle.NavPropsProductsEntityVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ODataExpandEntityCollectionTest
extends ODataEndpointTestBase {
    ODataExpandEntityCollectionTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(NavPropsProductsEntityVerticle.getDeclaredEntityModel());
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        CompositeFuture.all(this.deployVerticle((Verticle)new NavPropsProductsEntityVerticle()), this.deployVerticle((Verticle)new NavPropsCategoriesEntityVerticle())).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Expand property 'category' in Products")
    void testExpandCategoryInProducts(VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsProductsEntityVerticle.PRODUCTS_ENTITY_SET_FQN).setExpandQuery("category");
        List<JsonObject> expected = List.of(NavPropsProductsEntityVerticle.addCategoryToProduct(NavPropsProductsEntityVerticle.STEAK_PRODUCT, NavPropsCategoriesEntityVerticle.FOOD_CATEGORY), NavPropsProductsEntityVerticle.addCategoryToProduct(NavPropsProductsEntityVerticle.CHEESE_PRODUCT, NavPropsCategoriesEntityVerticle.FOOD_CATEGORY), NavPropsProductsEntityVerticle.addCategoryToProduct(NavPropsProductsEntityVerticle.S_1000_RR_PRODUCT, NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY), NavPropsProductsEntityVerticle.addCategoryToProduct(NavPropsProductsEntityVerticle.STREET_GLIDE_SPECIAL_PRODUCT, NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY));
        this.assertODataEntitySetContainsExactly(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Do not expand property 'category' in Products")
    void testDoNotExpandCategoryInProducts(VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsProductsEntityVerticle.PRODUCTS_ENTITY_SET_FQN);
        List<JsonObject> expected = NavPropsProductsEntityVerticle.ALL_PRODUCTS;
        this.assertODataEntitySetContainsExactly(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Expand property 'products' in Categories")
    void testExpandProductsInCategory(VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsCategoriesEntityVerticle.CATEGORIES_ENTITY_SET_FQN).setExpandQuery("products");
        List<JsonObject> expected = List.of(NavPropsCategoriesEntityVerticle.addProductsToCategory(NavPropsCategoriesEntityVerticle.FOOD_CATEGORY, List.of(NavPropsProductsEntityVerticle.STEAK_PRODUCT, NavPropsProductsEntityVerticle.CHEESE_PRODUCT)), NavPropsCategoriesEntityVerticle.addProductsToCategory(NavPropsCategoriesEntityVerticle.MOTORCYCLE_CATEGORY, List.of(NavPropsProductsEntityVerticle.S_1000_RR_PRODUCT, NavPropsProductsEntityVerticle.STREET_GLIDE_SPECIAL_PRODUCT)));
        this.assertODataEntitySetContainsExactly(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Do not expand property 'products' in Categories")
    void testDoNotExpandProductsInCategory(VertxTestContext testContext) {
        ODataRequest oDataRequest = new ODataRequest(NavPropsCategoriesEntityVerticle.CATEGORIES_ENTITY_SET_FQN);
        List<JsonObject> expected = NavPropsCategoriesEntityVerticle.ALL_CATEGORIES;
        this.assertODataEntitySetContainsExactly(this.requestOData(oDataRequest), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }
}

