/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import com.google.common.truth.Truth;
import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.TestService1EntityVerticle;
import io.vertx.core.Verticle;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class ODataOrderTest
extends ODataEndpointTestBase {
    private ODataRequest request;

    ODataOrderTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(TestService1EntityVerticle.getDeclaredEntityModel());
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        this.request = new ODataRequest(TestService1EntityVerticle.TEST_ENTITY_SET_FQN);
        this.deployVerticle((Verticle)new TestService1EntityVerticle()).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has test entities ordered (ordered by multiple properties asc)")
    void existingEntitiesOrderedMultipleAscTest(VertxTestContext testContext) {
        this.request.setQuery(Map.of("$orderby", "PropertyString,PropertyInt32 asc"));
        this.assertODataEntitySet(this.requestOData(this.request), entities -> Truth.assertThat((Iterable)entities).containsExactly(new Object[]{TestService1EntityVerticle.EXPECTED_ENTITY_DATA_1, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_3, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_6}).inOrder(), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has test entities ordered (ordered by multiple properties desc)")
    void existingEntitiesOrderedMultipleDescTest(VertxTestContext testContext) {
        this.request.setQuery(Map.of("$orderby", "PropertyString desc,PropertyInt32 desc"));
        this.assertODataEntitySet(this.requestOData(this.request), entities -> Truth.assertThat((Iterable)entities).containsExactly(new Object[]{TestService1EntityVerticle.EXPECTED_ENTITY_DATA_6, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_3, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_1}).inOrder(), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test ordering of Edm.Date properties in asc order")
    void orderingEdmDateAscTest(VertxTestContext testContext) {
        this.request.setQuery(Map.of("$orderby", "PropertyDate asc"));
        this.assertODataEntitySet(this.requestOData(this.request), entities -> Truth.assertThat((Iterable)entities).containsExactly(new Object[]{TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_3, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_1, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_6}).inOrder(), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test ordering of Edm.DateTimeOffset properties in desc order")
    void orderingEdmDateTimeOffsetDescTest(VertxTestContext testContext) {
        this.request.setQuery(Map.of("$orderby", "PropertyDateTime desc"));
        this.assertODataEntitySet(this.requestOData(this.request), entities -> Truth.assertThat((Iterable)entities).containsExactly(new Object[]{TestService1EntityVerticle.EXPECTED_ENTITY_DATA_6, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_1, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_3, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4, TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5}).inOrder(), testContext).onComplete(testContext.succeedingThenComplete());
    }
}

