/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata;

import com.google.common.base.Strings;
import com.google.common.truth.Truth;
import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.endpoint.odata.verticle.TestService1EntityVerticle;
import io.neonbee.test.endpoint.odata.verticle.TestService3EntityVerticle;
import io.vertx.core.CompositeFuture;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ODataReadEntityTest
extends ODataEndpointTestBase {
    private ODataRequestMod oDataRequest;

    ODataReadEntityTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(TestService1EntityVerticle.getDeclaredEntityModel(), TestService3EntityVerticle.getDeclaredEntityModel());
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void setUp(VertxTestContext testContext) {
        CompositeFuture.all(this.deployVerticle((Verticle)new TestService1EntityVerticle()), this.deployVerticle((Verticle)new TestService3EntityVerticle())).onComplete(testContext.succeedingThenComplete());
        this.oDataRequest = new ODataRequestMod(TestService1EntityVerticle.TEST_ENTITY_SET_FQN);
    }

    static Stream<Arguments> withInvalidKeys() {
        return Stream.of(Arguments.of((Object[])new Object[]{"(1337)", "wrong type"}), Arguments.of((Object[])new Object[]{"(+123+)", "invalid format"}));
    }

    @ParameterizedTest(name="{index}: with key {0} ({1})")
    @MethodSource(value={"withInvalidKeys"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 400 if an entity of an existing service is requested")
    void testInvalidKeys(String id, String reason, VertxTestContext testContext) {
        this.requestOData(this.oDataRequest.setKeyPredicate(id)).onComplete(testContext.succeeding(response -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)400);
            JsonObject jsonResponse = response.bodyAsJsonObject().getJsonObject("error");
            Truth.assertThat((String)jsonResponse.getString("code")).isNull();
            Truth.assertThat((String)jsonResponse.getString("message")).isEqualTo((Object)"The key value '' is invalid.");
            testContext.completeNow();
        }));
    }

    static Stream<Arguments> withValidKeys() {
        return Stream.of(Arguments.of((Object[])new Object[]{"id-1", TestService1EntityVerticle.EXPECTED_ENTITY_DATA_2}), Arguments.of((Object[])new Object[]{"id.3", TestService1EntityVerticle.EXPECTED_ENTITY_DATA_4}));
    }

    @ParameterizedTest(name="{index}: with key {0}")
    @MethodSource(value={"withValidKeys"})
    @DisplayName(value="Respond with 200 if the service exists and has entity")
    @Timeout(value=3, timeUnit=TimeUnit.SECONDS)
    void testFilter(String id, JsonObject expected, VertxTestContext testContext) {
        this.assertODataEntity(this.requestOData(this.oDataRequest.setKey(id)), expected, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with the value of the requests attribute of the entity")
    void readEntityPropertyTest(VertxTestContext testContext) {
        this.assertODataEntity(this.requestOData(this.oDataRequest.setKey("id-4").setProperty("PropertyInt32")), new JsonObject().put("value", (Object)4), testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has entity with id")
    void existingEntity5WithUrlEncodedSingleQuotesTest(VertxTestContext testContext) {
        this.oDataRequest.setKeyPredicate("(%27id-4%27)");
        this.assertODataEntity(this.requestOData(this.oDataRequest), TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has entity with id")
    void existingEntity5WithUrlEncodedParenthesisAndSingleQuotesTest(VertxTestContext testContext) {
        this.oDataRequest.setKeyPredicate("%28%27id-4%27%29");
        this.assertODataEntity(this.requestOData(this.oDataRequest), TestService1EntityVerticle.EXPECTED_ENTITY_DATA_5, testContext).onComplete(testContext.succeedingThenComplete());
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Respond with 200 if the service is existing and has entity with (Edm.Int32) id")
    void existingEntity205Test(VertxTestContext testContext) {
        this.oDataRequest = new ODataRequestMod(TestService3EntityVerticle.TEST_ENTITY_SET_FQN);
        this.oDataRequest.setKey(205L);
        this.assertODataEntity(this.requestOData(this.oDataRequest), TestService3EntityVerticle.ENTITY_DATA_3, testContext).onComplete(testContext.succeedingThenComplete());
    }

    static class ODataRequestMod
    extends ODataRequest {
        private final FullQualifiedName entity;
        private String keyPredicate;

        ODataRequestMod(FullQualifiedName entity) {
            super(entity);
            this.entity = entity;
        }

        @Override
        public ODataRequest setMethod(HttpMethod method) {
            super.setMethod(method);
            return this;
        }

        @Override
        public ODataRequest setBody(Buffer body) {
            super.setBody(body);
            return this;
        }

        @Override
        public ODataRequest setMetadata() {
            super.setMetadata();
            return this;
        }

        @Override
        public ODataRequest setCount() {
            super.setCount();
            return this;
        }

        @Override
        public ODataRequestMod setKey(String id) {
            super.setKey(id);
            return this;
        }

        @Override
        public ODataRequest setKey(long id) {
            super.setKey(id);
            return this;
        }

        @Override
        public ODataRequest setKey(Map<String, Object> compositeKey) {
            super.setKey(compositeKey);
            return this;
        }

        @Override
        public ODataRequest setProperty(String propertyName) {
            super.setProperty(propertyName);
            return this;
        }

        @Override
        public ODataRequest addQueryParam(String key, String value) {
            super.addQueryParam(key, value);
            return this;
        }

        @Override
        public ODataRequest setQuery(Map<String, String> parameters) {
            super.setQuery(parameters);
            return this;
        }

        @Override
        public ODataRequest addHeader(String key, String value) {
            super.addHeader(key, value);
            return this;
        }

        @Override
        public ODataRequest setHeaders(MultiMap headers) {
            super.setHeaders(headers);
            return this;
        }

        @Override
        public ODataRequest interceptRequest(Consumer<HttpRequest<Buffer>> rawRequest) {
            super.interceptRequest(rawRequest);
            return this;
        }

        @Override
        protected String getUri() {
            if (Strings.isNullOrEmpty((String)this.keyPredicate)) {
                return super.getUri();
            }
            return Strings.isNullOrEmpty((String)this.entity.getNamespace()) ? "" : this.entity.getNamespace() + "/" + this.entity.getName() + this.keyPredicate;
        }

        public ODataRequestMod setKeyPredicate(String key) {
            this.keyPredicate = key;
            return this;
        }
    }
}

