/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata.verticle;

import io.neonbee.data.DataContext;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class NavPropsProductsEntityVerticle
extends EntityVerticle {
    public static final FullQualifiedName PRODUCTS_ENTITY_SET_FQN = new FullQualifiedName("io.neonbee.test.NavProbs", "Products");
    public static final String PROPERTY_NAME_ID = "ID";
    public static final String PROPERTY_NAME_NAME = "name";
    public static final String PROPERTY_NAME_CATEGORY_ID = "category_ID";
    public static final String PROPERTY_NAME_CATEGORY = "category";
    public static final JsonObject STEAK_PRODUCT = NavPropsProductsEntityVerticle.createProduct(1, "Steak", 1);
    public static final JsonObject CHEESE_PRODUCT = NavPropsProductsEntityVerticle.createProduct(2, "Cheese", 1);
    public static final JsonObject S_1000_RR_PRODUCT = NavPropsProductsEntityVerticle.createProduct(21, "S 1000 RR", 2);
    public static final JsonObject STREET_GLIDE_SPECIAL_PRODUCT = NavPropsProductsEntityVerticle.createProduct(22, "Street Glide Special", 2);
    public static final List<JsonObject> ALL_PRODUCTS = List.of(STEAK_PRODUCT, CHEESE_PRODUCT, S_1000_RR_PRODUCT, STREET_GLIDE_SPECIAL_PRODUCT);

    public Future<Set<FullQualifiedName>> entityTypeNames() {
        return Future.succeededFuture(Set.of(PRODUCTS_ENTITY_SET_FQN));
    }

    public Future<EntityWrapper> retrieveData(DataQuery query, DataMap require, DataContext context) {
        List allEntities = ALL_PRODUCTS.stream().map(NavPropsProductsEntityVerticle::createProduct).collect(Collectors.toList());
        return Future.succeededFuture((Object)new EntityWrapper(PRODUCTS_ENTITY_SET_FQN, allEntities));
    }

    public static Entity createProduct(JsonObject category) {
        return new Entity().addProperty(new Property(null, PROPERTY_NAME_ID, ValueType.PRIMITIVE, (Object)category.getInteger(PROPERTY_NAME_ID))).addProperty(new Property(null, PROPERTY_NAME_NAME, ValueType.PRIMITIVE, (Object)category.getString(PROPERTY_NAME_NAME))).addProperty(new Property(null, PROPERTY_NAME_CATEGORY_ID, ValueType.PRIMITIVE, (Object)category.getInteger(PROPERTY_NAME_CATEGORY_ID)));
    }

    public static JsonObject createProduct(int id, String name, int categoryId) {
        return new JsonObject().put(PROPERTY_NAME_ID, (Object)id).put(PROPERTY_NAME_NAME, (Object)name).put(PROPERTY_NAME_CATEGORY_ID, (Object)categoryId);
    }

    public static JsonObject addCategoryToProduct(JsonObject product, JsonObject expanedCategory) {
        return product.copy().put(PROPERTY_NAME_CATEGORY, (Object)expanedCategory.copy());
    }

    public static Path getDeclaredEntityModel() {
        return ResourceHelper.TEST_RESOURCES.resolveRelated("NavigationProperty.csn");
    }
}

