/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.odata.verticle;

import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.test.helper.EntityHelper;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class TestServiceCompoundKeyEntityVerticle
extends EntityVerticle {
    public static final FullQualifiedName TEST_ENTITY_SET_FQN = new FullQualifiedName("io.neonbee.compoundkey.TestServiceCompoundKey", "TestCars");
    public static final JsonObject ENTITY_DATA_1 = TestServiceCompoundKeyEntityVerticle.createEntityData(0, "2020-02-02", "Car 0", "The first car");
    public static final JsonObject ENTITY_DATA_2 = TestServiceCompoundKeyEntityVerticle.createEntityData(1, "2020-02-02", "Car 1", "The second car");
    public static final JsonObject ENTITY_DATA_3 = TestServiceCompoundKeyEntityVerticle.createEntityData(2, "2020-02-02", "Car 2", "The third car");

    public Future<Set<FullQualifiedName>> entityTypeNames() {
        return Future.succeededFuture(Set.of(TEST_ENTITY_SET_FQN));
    }

    public Future<EntityWrapper> updateData(DataQuery query, DataContext context) {
        return Future.succeededFuture((Object)new EntityWrapper(TEST_ENTITY_SET_FQN, (Entity)null));
    }

    public Future<EntityWrapper> retrieveData(DataQuery query, DataContext context) {
        return Future.succeededFuture((Object)new EntityWrapper(TEST_ENTITY_SET_FQN, List.of(EntityHelper.createEntity(ENTITY_DATA_1), EntityHelper.createEntity(ENTITY_DATA_2), EntityHelper.createEntity(ENTITY_DATA_3))));
    }

    public static Path getDeclaredEntityModel() {
        return ResourceHelper.TEST_RESOURCES.resolveRelated("TestServiceCompoundKey.csn");
    }

    public static JsonObject createEntityData(int id, String date, String name, String description) {
        long epochSeconds = LocalDate.parse(date).atStartOfDay().toInstant(ZoneOffset.UTC).getEpochSecond();
        JsonObject entityData = new JsonObject();
        entityData.put("ID", (Object)id);
        entityData.put("date", (Object)epochSeconds);
        entityData.put("name", (Object)name);
        entityData.put("description", (Object)description);
        return entityData;
    }
}

