/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.endpoint.openapi;

import com.google.common.truth.Truth;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfig;
import io.neonbee.internal.verticle.ServerVerticle;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.endpoint.openapi.PetStoreEndpoint;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class PetStoreTest
extends NeonBeeTestBase {
    private static final String PET1_NAME = "Peter";
    private static final String PET2_NAME = "Horst";
    private static final JsonObject PET1 = new JsonObject().put("id", (Object)1).put("name", (Object)"Peter");
    private static final JsonObject PET2 = new JsonObject().put("id", (Object)2).put("name", (Object)"Horst");

    PetStoreTest() {
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        WorkingDirectoryBuilder dirBuilder = WorkingDirectoryBuilder.standard();
        return dirBuilder.setCustomTask(workingDir -> {
            DeploymentOptions opts = WorkingDirectoryBuilder.readDeploymentOptions(ServerVerticle.class, workingDir);
            EndpointConfig epc = new EndpointConfig().setType(PetStoreEndpoint.class.getName());
            ServerConfig sc = new ServerConfig(opts.getConfig()).setEndpointConfigs(List.of(epc));
            opts.setConfig(sc.toJson());
            WorkingDirectoryBuilder.writeDeploymentOptions(ServerVerticle.class, opts, workingDir);
        });
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should create, get and list pets")
    void cycleTest(VertxTestContext testContext) {
        Checkpoint create = testContext.checkpoint();
        Checkpoint get = testContext.checkpoint();
        Checkpoint list = testContext.checkpoint();
        this.createPet(new JsonObject().put("name", (Object)PET1_NAME)).compose(resp -> {
            testContext.verify(() -> Truth.assertThat((Integer)resp.statusCode()).isEqualTo((Object)201));
            create.flag();
            return this.getPet("1");
        }).compose(pet -> {
            testContext.verify(() -> Truth.assertThat((Iterable)pet).isEqualTo((Object)PET1));
            get.flag();
            return this.createPet(new JsonObject().put("name", (Object)PET2_NAME)).compose(v -> this.getPets());
        }).onComplete(testContext.succeeding(pets -> {
            testContext.verify(() -> Truth.assertThat((Iterable)pets).containsExactly(new Object[]{PET1, PET2}));
            list.flag();
        }));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should fail when passed parameters are invalid")
    void validationTest(VertxTestContext testContext) {
        String expectedErrorMsg = "Error 400: [Bad Request] Validation error for body application/json: provided object should contain property name";
        this.createPet(new JsonObject().put("invalidParam", (Object)PET1_NAME)).onComplete(testContext.succeeding(resp -> testContext.verify(() -> {
            Truth.assertThat((Integer)resp.statusCode()).isEqualTo((Object)400);
            Truth.assertThat((String)resp.statusMessage()).isEqualTo((Object)"Bad Request");
            Truth.assertThat((String)resp.bodyAsString()).contains((CharSequence)expectedErrorMsg);
            testContext.completeNow();
        })));
    }

    @Override
    public HttpRequest<Buffer> createRequest(HttpMethod method, String path) {
        return super.createRequest(method, "/petstore/" + path);
    }

    Future<HttpResponse<Buffer>> createPet(JsonObject pet) {
        return this.createRequest(HttpMethod.POST, "pets").sendJsonObject(pet);
    }

    Future<JsonArray> getPets() {
        return this.createRequest(HttpMethod.GET, "pets").send().map(HttpResponse::bodyAsJsonArray);
    }

    Future<JsonObject> getPet(String id) {
        return this.createRequest(HttpMethod.GET, "pets/" + id).send().map(HttpResponse::bodyAsJsonObject);
    }
}

