/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlCollection;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlConstantExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPath;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyValue;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlRecord;

public class AnnotationHelper {
    public static CsdlAnnotations createConstantAnnotations(String target, String term, String property, String value) {
        return AnnotationHelper.createConstantAnnotations(target, term, property, CsdlConstantExpression.ConstantExpressionType.String, value);
    }

    public static CsdlAnnotations createConstantAnnotations(String target, String term, String property, CsdlConstantExpression.ConstantExpressionType type, String value) {
        CsdlConstantExpression expression = new CsdlConstantExpression(type);
        expression.setValue(value);
        return AnnotationHelper.createAnnotations(target, term, property, (CsdlExpression)expression);
    }

    public static CsdlAnnotations createPathAnnotations(String target, String term, String property, String value) {
        CsdlPath expression = new CsdlPath();
        expression.setValue(value);
        return AnnotationHelper.createAnnotations(target, term, property, (CsdlExpression)expression);
    }

    public static CsdlAnnotations createConstantCollectionAnnotations(String target, String term, String property, String ... values) {
        CsdlCollection expression = new CsdlCollection();
        expression.setItems(Arrays.stream(values).map(value -> {
            CsdlConstantExpression item = new CsdlConstantExpression(CsdlConstantExpression.ConstantExpressionType.String);
            item.setValue(value);
            return item;
        }).collect(Collectors.toList()));
        return AnnotationHelper.createAnnotations(target, term, property, (CsdlExpression)expression);
    }

    public static CsdlAnnotations createPathCollectionAnnotations(String target, String term, String property, String ... values) {
        CsdlCollection expression = new CsdlCollection();
        expression.setItems(Arrays.stream(values).map(value -> {
            CsdlPath path = new CsdlPath();
            path.setValue(value);
            return path;
        }).collect(Collectors.toList()));
        return AnnotationHelper.createAnnotations(target, term, property, (CsdlExpression)expression);
    }

    public static CsdlAnnotations createAnnotations(String target, String term, String property, CsdlExpression expression) {
        CsdlAnnotations annotations = new CsdlAnnotations();
        annotations.setTarget(target);
        CsdlAnnotation annotation = new CsdlAnnotation();
        annotation.setTerm(term);
        CsdlRecord record = new CsdlRecord();
        CsdlPropertyValue propertyValue = new CsdlPropertyValue();
        propertyValue.setProperty(property);
        propertyValue.setValue(expression);
        record.setPropertyValues(List.of(propertyValue));
        annotation.setExpression((CsdlExpression)record);
        annotations.setAnnotations(List.of(annotation));
        return annotations;
    }
}

