/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import io.neonbee.data.DataAdapter;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataVerticle;
import io.neonbee.entity.EntityVerticle;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.test.helper.ReflectionHelper;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.FullQualifiedName;

public class DummyVerticleHelper {
    public static final Verticle DUMMY_VERTICLE = new AbstractVerticle(){};

    public static DummyDataVerticleFactory createDummyDataVerticle(String fqn) {
        return new DummyDataVerticleFactory(fqn);
    }

    public static DummyEntityVerticleFactory createDummyEntityVerticle(FullQualifiedName fqn) {
        return new DummyEntityVerticleFactory(fqn);
    }

    public static class DummyDataVerticleFactory {
        private final String fqn;

        private DummyDataVerticleFactory(String fqn) {
            this.fqn = fqn;
        }

        public <T> DataVerticle<T> withStaticResponse(T response) {
            return this.withDynamicResponse((query, context) -> response);
        }

        public <T> DataVerticle<T> withDynamicResponse(final BiFunction<DataQuery, DataContext, T> response) {
            return this.withDataAdapter(new DataAdapter<T>(){

                public Future<T> retrieveData(DataQuery query, DataContext context) {
                    return Future.succeededFuture(response.apply(query, context));
                }
            });
        }

        public DataVerticle<?> withDynamicException(final BiFunction<DataQuery, DataContext, Exception> response) {
            return this.withDataAdapter(new DataAdapter<Object>(){

                public Future<Object> retrieveData(DataQuery query, DataContext context) {
                    return Future.failedFuture((Throwable)((Throwable)response.apply(query, context)));
                }
            });
        }

        public <T> DataVerticle<T> withDataAdapter(final DataAdapter<T> dataAdapter) {
            final int beginNameIdx = this.fqn.lastIndexOf(47);
            DataVerticle dummyVerticle = new DataVerticle<T>(){

                public Future<T> createData(DataQuery query, DataContext context) {
                    return dataAdapter.createData(query, context);
                }

                public Future<T> retrieveData(DataQuery query, DataContext context) {
                    return dataAdapter.retrieveData(query, context);
                }

                public Future<T> deleteData(DataQuery query, DataContext context) {
                    return dataAdapter.deleteData(query, context);
                }

                public Future<T> updateData(DataQuery query, DataContext context) {
                    return dataAdapter.updateData(query, context);
                }

                public String getName() {
                    return beginNameIdx <= 0 ? fqn : fqn.substring(beginNameIdx + 1);
                }
            };
            try {
                Supplier<String> dummySupplier = () -> beginNameIdx <= 0 ? null : this.fqn.substring(0, beginNameIdx);
                ReflectionHelper.setValueOfPrivateField(dummyVerticle, "namespaceSupplier", dummySupplier);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return dummyVerticle;
        }
    }

    public static class DummyEntityVerticleFactory {
        private final FullQualifiedName fqn;

        private DummyEntityVerticleFactory(FullQualifiedName fqn) {
            this.fqn = fqn;
        }

        public EntityVerticle withStaticResponse(Entity response) {
            return this.withStaticResponse(Optional.ofNullable(response).map(r -> List.of(r)).orElse(List.of()));
        }

        public EntityVerticle withStaticResponse(List<Entity> response) {
            return this.withDynamicResponse((query, context) -> new EntityWrapper(this.fqn, response));
        }

        public EntityVerticle withDynamicResponse(final BiFunction<DataQuery, DataContext, EntityWrapper> response) {
            return this.withDataAdapter(new DataAdapter<EntityWrapper>(){

                public Future<EntityWrapper> retrieveData(DataQuery query, DataContext context) {
                    return Future.succeededFuture((Object)((EntityWrapper)response.apply(query, context)));
                }
            });
        }

        public EntityVerticle withDynamicException(final BiFunction<DataQuery, DataContext, Exception> response) {
            return this.withDataAdapter(new DataAdapter<EntityWrapper>(){

                public Future<EntityWrapper> retrieveData(DataQuery query, DataContext context) {
                    return Future.failedFuture((Throwable)((Throwable)response.apply(query, context)));
                }
            });
        }

        public EntityVerticle withDataAdapter(final DataAdapter<EntityWrapper> dataAdapter) {
            return new EntityVerticle(){

                public Future<EntityWrapper> retrieveData(DataQuery query, DataContext context) {
                    return dataAdapter.retrieveData(query, context);
                }

                public Future<EntityWrapper> createData(DataQuery query, DataContext context) {
                    return dataAdapter.createData(query, context);
                }

                public Future<EntityWrapper> updateData(DataQuery query, DataContext context) {
                    return dataAdapter.updateData(query, context);
                }

                public Future<EntityWrapper> deleteData(DataQuery query, DataContext context) {
                    return dataAdapter.deleteData(query, context);
                }

                public Future<Set<FullQualifiedName>> entityTypeNames() {
                    return Future.succeededFuture(Set.of(fqn));
                }
            };
        }
    }
}

