/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import com.google.common.truth.Truth;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.VertxTestContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;

public final class EntityHelper {
    private EntityHelper() {
    }

    public static Entity createEntity(JsonObject entityData) {
        Entity entity = new Entity();
        entityData.fieldNames().stream().forEach(fieldName -> entity.addProperty(new Property(null, fieldName, ValueType.PRIMITIVE, entityData.getValue(fieldName))));
        return entity;
    }

    public static void compareLazy(Entity expectedEntity, Entity entity, VertxTestContext testContext, String ... ignoreFields) {
        testContext.verify(() -> {
            List<String> ignore = List.of(ignoreFields);
            Truth.assertThat(EntityHelper.toMap(entity, ignore)).containsExactlyEntriesIn(EntityHelper.toMap(expectedEntity, ignore));
        });
    }

    private static Map<String, Object> toMap(Entity entity, List<String> ignoreFields) {
        HashMap<String, Object> mapToReturn = new HashMap<String, Object>();
        entity.getProperties().forEach(prop -> {
            if (!ignoreFields.contains(prop.getName())) {
                mapToReturn.put(prop.getName(), prop.getValue());
            }
        });
        return mapToReturn;
    }
}

