/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.impl.FileSystemImpl;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileSystemHelper {
    @Deprecated(forRemoval=true)
    public static Future<Void> deleteRecursive(Path path) {
        Vertx vertx = Vertx.vertx();
        return FileSystemHelper.deleteRecursive(vertx, path).eventually(throwable -> vertx.close());
    }

    public static Future<Void> deleteRecursive(Vertx vertx, Path path) {
        return vertx.fileSystem().deleteRecursive(path.toString(), true);
    }

    public static void deleteRecursiveBlocking(Path path) {
        try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
            FileSystemImpl.delete((Path)path, (boolean)true);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public static void deleteRecursiveBlocking(Vertx vertx, Path path) {
        vertx.fileSystem().deleteRecursiveBlocking(path.toString(), true);
    }

    public static void copyDirectory(Path srcDirPath, Path destDirPath) throws IOException {
        try (Stream<Path> stream = Files.walk(srcDirPath, new FileVisitOption[0]);){
            ArrayList orderedPaths = new ArrayList();
            stream.forEachOrdered(orderedPaths::add);
            for (Path path : orderedPaths) {
                Files.copy(path, destDirPath.resolve(srcDirPath.relativize(path)), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static void extractZipFile(Path zipFile, Path destDirPath) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInput.getNextEntry()) != null) {
                Path destPath = destDirPath.resolve(zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(destPath, new FileAttribute[0]);
                    continue;
                }
                Files.copy(zipInput, destPath, new CopyOption[0]);
            }
            zipInput.closeEntry();
        }
    }

    public static Path createTempDirectory() throws IOException {
        return Files.createTempDirectory(FileSystemHelper.class.getName(), new FileAttribute[0]);
    }

    private FileSystemHelper() {
    }
}

