/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.helper;

import com.google.common.base.Strings;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.NeonBeeOptions;
import io.neonbee.test.helper.SystemHelper;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OptionsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionsHelper.class);

    private static NeonBeeInstanceConfiguration defaultInstanceConfiguration() {
        return OptionsHelper.internalDefaultInstanceConfiguration(null);
    }

    private static NeonBeeInstanceConfiguration internalDefaultInstanceConfiguration(@NeonBeeInstanceConfiguration Void nothing) {
        try {
            return OptionsHelper.class.getDeclaredMethod("internalDefaultInstanceConfiguration", Void.class).getParameters()[0].getAnnotation(NeonBeeInstanceConfiguration.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeonBeeOptions.Mutable defaultOptions() {
        return OptionsHelper.options(Optional.empty());
    }

    public static NeonBeeOptions.Mutable options(Optional<NeonBeeInstanceConfiguration> config) {
        return OptionsHelper.options(config.orElseGet(OptionsHelper::defaultInstanceConfiguration));
    }

    public static NeonBeeOptions.Mutable options(NeonBeeInstanceConfiguration config) {
        int port;
        try {
            port = SystemHelper.getFreePort();
        }
        catch (IOException e) {
            LOGGER.error("Error while finding a free port for server verticle.", (Throwable)e);
            throw new RuntimeException(e);
        }
        NeonBeeOptions.Mutable options = new NeonBeeOptions.Mutable();
        options.setActiveProfiles(Arrays.asList(config.activeProfiles())).setClusterConfigResource(config.clusterConfigFile()).setClustered(config.clustered()).setClusterPort(config.clusterPort()).setDisableJobScheduling(config.disableJobScheduling()).setDoNotWatchFiles(config.doNotWatchFiles()).setEventLoopPoolSize(config.eventLoopPoolSize()).setIgnoreClassPath(config.ignoreClassPath()).setServerPort(Integer.valueOf(port)).setWorkerPoolSize(config.workerPoolSize()).setWorkingDirectory(Paths.get(config.workingDirectoryPath(), new String[0]));
        if (!Strings.isNullOrEmpty((String)config.instanceName())) {
            options.setInstanceName(config.instanceName());
        }
        return options;
    }
}

