/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.test.listeners;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.neonbee.test.listeners.StaleThreadChecker;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxThread;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaleVertxChecker
extends StaleThreadChecker {
    public static final SetMultimap<Vertx, String> VERTX_TEST_MAP = HashMultimap.create();
    private static final int STALE_CHECK_THREAD_POOL_SIZE = 5;
    private static final ExecutorService STALE_CHECK_EXECUTOR;
    private static final Logger LOGGER;
    private static final Method CONTEXT_METHOD;

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        STALE_CHECK_EXECUTOR.submit(() -> {
            super.executionFinished(testIdentifier, testExecutionResult);
            if (CONTEXT_METHOD != null) {
                this.checkForStaleVertxInstances(testIdentifier);
            }
        });
    }

    private void checkForStaleVertxInstances(TestIdentifier testIdentifier) {
        LOGGER.info("Checking for stale Vert.x instances");
        Set vertxInstances = StaleVertxChecker.findStaleThreads("vert.x-").filter(VertxThread.class::isInstance).map(VertxThread.class::cast).map(thread -> {
            try {
                Context context = (Context)CONTEXT_METHOD.invoke(thread, new Object[0]);
                if (context == null) {
                    return null;
                }
                Vertx vertx = context.owner();
                if (vertx == null) {
                    LOGGER.error("Vert.x thread {} has a context {} with no owner, is this a bug?!", (Object)context, thread);
                    return null;
                }
                return vertx;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.error("Failed to determine Vert.x context for thread {}", thread);
                return null;
            }
        }).collect(Collectors.toSet());
        if (vertxInstances.isEmpty()) {
            LOGGER.info("No stale Vert.x instances found");
            return;
        }
        if (vertxInstances.contains(null)) {
            LOGGER.warn("Could not determine Vert.x instance for all Vert.x threads");
        }
        HashSet<Vertx> unassociatedVertxInstances = new HashSet<Vertx>();
        HashSet<Vertx> associatedVertxInstances = new HashSet<Vertx>();
        HashSet notAssociatedVertxInstances = new HashSet();
        vertxInstances.stream().filter(Objects::nonNull).forEach(vertx -> {
            Set associatedToTests = VERTX_TEST_MAP.get(vertx);
            if (associatedToTests.isEmpty()) {
                unassociatedVertxInstances.add((Vertx)vertx);
            } else if (associatedToTests.contains(testIdentifier.getDisplayName())) {
                associatedVertxInstances.add((Vertx)vertx);
            } else {
                notAssociatedVertxInstances.add(vertx);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Vert.x instance overview:\n\nUnassociated: {}\nAssociated: {}\nNot Associated: {}", new Object[]{unassociatedVertxInstances, associatedVertxInstances, notAssociatedVertxInstances});
        }
        if (!associatedVertxInstances.isEmpty()) {
            this.logStaleVertxInstances(associatedVertxInstances);
        } else if (!(this.parallelExecution || unassociatedVertxInstances.isEmpty() && !vertxInstances.contains(null))) {
            if (!unassociatedVertxInstances.isEmpty()) {
                this.logStaleVertxInstances(unassociatedVertxInstances);
            } else if (vertxInstances.contains(null)) {
                // empty if block
            }
        }
    }

    private void logStaleVertxInstances(Collection<Vertx> vertxInstances) {
        Optional<Vertx> notRunningVertx = vertxInstances.stream().filter(Predicate.not(StaleVertxChecker::probeVertxRunning)).findAny();
        if (!notRunningVertx.isPresent()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Stale and running Vert.x instance found!! Not closing Vert.x instance {} could result in the test runner not signaling completion", vertxInstances.stream().findAny());
            }
        } else {
            LOGGER.error("Stale closed (!) Vert.x instance {} with running threads found!! This is a bug!", (Object)notRunningVertx.get());
        }
    }

    private static boolean probeVertxRunning(Vertx vertx) {
        try {
            vertx.deployVerticle(() -> null, new DeploymentOptions().setInstances(0));
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    static {
        AtomicInteger threadIndex = new AtomicInteger();
        STALE_CHECK_EXECUTOR = Executors.newFixedThreadPool(5, runnable -> {
            Thread thread = new Thread(runnable, "neonbee-stale-vertx-thread-checker-" + threadIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
        LOGGER = LoggerFactory.getLogger(StaleVertxChecker.class);
        Method contextMethod = null;
        try {
            contextMethod = VertxThread.class.getDeclaredMethod("context", new Class[0]);
            contextMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("Cannot set context method of VertxThread accessible, checking for stale threads is limited");
        }
        finally {
            CONTEXT_METHOD = contextMethod;
        }
    }
}

