/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.truth.Truth;
import com.hazelcast.config.ClasspathXmlConfig;
import io.neonbee.Launcher;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.test.helper.FileSystemHelper;
import io.neonbee.test.helper.SystemHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.cli.Argument;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.MissingValueException;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.core.cli.impl.DefaultCommandLine;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@Isolated(value="some tests modify the global ProcessEnvironment using SystemHelper.withEnvironment")
class LauncherTest {
    private static Path tempDirPath;
    private String[] args;
    private static String workDir;

    LauncherTest() {
    }

    @BeforeAll
    static void setUp() throws IOException {
        tempDirPath = FileSystemHelper.createTempDirectory();
        workDir = tempDirPath.toAbsolutePath().toString();
    }

    @AfterAll
    static void tearDown() {
        FileSystemHelper.deleteRecursiveBlocking(tempDirPath);
    }

    @Test
    @DisplayName(value="should throw an error, if working directory value is not passed")
    void throwErrorIfWorkingDirValueIsEmpty() {
        this.args = new String[]{"-cwd"};
        MissingValueException exception = (MissingValueException)Assertions.assertThrows(MissingValueException.class, this::parseArgs);
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"The option 'working-directory' requires a value");
    }

    @Test
    @DisplayName(value="should have NeonBeeProfile ALL by default")
    void testDefaultActiveProfiles() {
        this.args = new String[0];
        Truth.assertThat((Iterable)this.parseArgs().getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.ALL});
    }

    @Test
    @DisplayName(value="should have WEB as active profile")
    void testSingleActiveProfiles() {
        this.args = new String[]{"-ap", "WEB"};
        Truth.assertThat((Iterable)this.parseArgs().getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.WEB});
    }

    @Test
    @DisplayName(value="should have ALL and WEB as active profiles")
    void testMultiStringActiveProfiles() {
        this.args = new String[]{"-ap", "WEB,ALL"};
        Truth.assertThat((Iterable)this.parseArgs().getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.WEB, NeonBeeProfile.ALL});
    }

    @Test
    @DisplayName(value="should have no NeonBeeProfile if empty")
    void testMultiValueActiveProfiles() {
        this.args = new String[]{"-ap", "WEB", "ALL"};
        Truth.assertThat((Iterable)this.parseArgs().getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.WEB, NeonBeeProfile.ALL});
    }

    @Test
    @DisplayName(value="should have no NeonBeeProfile if empty")
    void testEmptyActiveProfiles() {
        this.args = new String[]{"-ap", ""};
        Truth.assertThat((Iterable)this.parseArgs().getActiveProfiles()).isEmpty();
    }

    @Test
    @DisplayName(value="should throw an error, if instance-name is empty")
    void throwErrorIfInstanceNameIsEmpty() {
        this.args = new String[]{"-cwd", workDir, "-name", ""};
        CLIException exception = (CLIException)Assertions.assertThrows(CLIException.class, this::parseArgs);
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"Cannot inject value for option 'instance-name'");
    }

    @Test
    @DisplayName(value="should throw error, if the passed value is other than integer for worker pool size")
    void validateWorkerPoolSizeValue() {
        this.args = new String[]{"-cwd", workDir, "-name", "Hodor", "-wps", "hodor"};
        CLIException exception = (CLIException)Assertions.assertThrows(CLIException.class, this::parseArgs);
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"Cannot inject value for option 'worker-pool-size'");
    }

    @Test
    @DisplayName(value="should throw error, if the passed value is other than integer for event loop pool size")
    void validateEventLoopPoolSizeValue() {
        this.args = new String[]{"-cwd", workDir, "-name", "Hodor", "-elps", "hodor"};
        CLIException exception = (CLIException)Assertions.assertThrows(CLIException.class, this::parseArgs);
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"Cannot inject value for option 'event-loop-pool-size'");
    }

    @Test
    @DisplayName(value="should generate expected neonbee options")
    void testExpectedNeonBeeOptions() throws Exception {
        this.args = new String[]{"-cwd", workDir, "-name", "Hodor", "-wps", "2", "-elps", "2", "-no-cp", "-no-jobs", "-port", "9000", "-mjp", "path1", "path2", "path3" + File.pathSeparator + "path4"};
        this.assertNeonBeeOptions();
        this.args = new String[0];
        Truth.assertThat((Integer)this.parseArgs().getServerPort()).isNull();
    }

    @Test
    @DisplayName(value="should generate expected neonbee options")
    void testExpectedNeonBeeEnvironmentOptions() throws Exception {
        this.args = new String[0];
        Map<String, CallSite> envMap = Map.of("NEONBEE_WORKING_DIR", workDir, "NEONBEE_INSTANCE_NAME", "Hodor", "NEONBEE_WORKER_POOL_SIZE", "2", "NEONBEE_EVENT_LOOP_POOL_SIZE", "2", "NEONBEE_IGNORE_CLASS_PATH", "true", "NEONBEE_DISABLE_JOB_SCHEDULING", "true", "NEONBEE_SERVER_PORT", "9000", "NEONBEE_MODULE_JAR_PATHS", "path1" + File.pathSeparator + "path2" + File.pathSeparator + "path3" + File.pathSeparator + "path4");
        SystemHelper.withEnvironment(envMap, this::assertNeonBeeOptions);
    }

    @Test
    @DisplayName(value="should generate expected clustered neonbee options")
    void testExpectedClusterNeonBeeOptions() throws Exception {
        this.args = new String[]{"-cwd", workDir, "-cl", "-cc", "hazelcast-local.xml", "-clp", "10000"};
        this.assertClusteredOptions();
        this.args = new String[0];
        Map<String, String> envMap = Map.of("NEONBEE_WORKING_DIR", workDir, "NEONBEE_CLUSTERED", "true", "NEONBEE_CLUSTER_CONFIG", "hazelcast-local.xml", "NEONBEE_CLUSTER_PORT", "10000");
        SystemHelper.withEnvironment(envMap, this::assertClusteredOptions);
    }

    @Test
    @DisplayName(value="test EnvironmentAwareCommandLine")
    void testEnvironmentAwareCommandLine() {
        CLI cliMock = (CLI)Mockito.mock(CLI.class);
        Option option = new Option().setLongName("option");
        Mockito.when((Object)cliMock.getOption((String)ArgumentMatchers.any())).thenReturn((Object)option);
        Option flag = new Option().setLongName("flag").setFlag(true);
        Mockito.when((Object)cliMock.getOption("flag")).thenReturn((Object)flag);
        Argument argument = new Argument();
        Mockito.when((Object)cliMock.getArgument((String)ArgumentMatchers.any())).thenReturn((Object)argument);
        Mockito.when((Object)cliMock.getArgument(ArgumentMatchers.anyInt())).thenReturn((Object)argument);
        CommandLine commandLineMock = (CommandLine)Mockito.mock(DefaultCommandLine.class);
        Mockito.when((Object)commandLineMock.cli()).thenReturn((Object)cliMock);
        Launcher.EnvironmentAwareCommandLine commandLine = (Launcher.EnvironmentAwareCommandLine)Mockito.spy((Object)new Launcher.EnvironmentAwareCommandLine(commandLineMock));
        Mockito.clearInvocations((Object[])new Launcher.EnvironmentAwareCommandLine[]{commandLine});
        commandLine.isFlagEnabled("flag");
        ((Launcher.EnvironmentAwareCommandLine)Mockito.verify((Object)commandLine)).hasEnvArg((Option)ArgumentMatchers.any());
        Mockito.clearInvocations((Object[])new Launcher.EnvironmentAwareCommandLine[]{commandLine});
        commandLine.isSeenInCommandLine(option);
        ((Launcher.EnvironmentAwareCommandLine)Mockito.verify((Object)commandLine)).hasEnvArg((Option)ArgumentMatchers.any());
        Mockito.clearInvocations((Object[])new Launcher.EnvironmentAwareCommandLine[]{commandLine});
        commandLine.getRawValueForOption(option);
        ((Launcher.EnvironmentAwareCommandLine)Mockito.verify((Object)commandLine)).hasEnvArg(option);
        Mockito.clearInvocations((Object[])new Launcher.EnvironmentAwareCommandLine[]{commandLine});
        commandLine.getRawValuesForOption(option);
        ((Launcher.EnvironmentAwareCommandLine)Mockito.verify((Object)commandLine)).hasEnvArg(option);
    }

    @Test
    void testStartNeonBeeConfigPath() {
        NeonBeeOptions.Mutable options = new NeonBeeOptions.Mutable();
        Path tempDirectory = Path.of("some", "test", "path").toAbsolutePath();
        options.setWorkingDirectory(tempDirectory);
        try (MockedStatic staticNbc = Mockito.mockStatic(NeonBeeConfig.class);){
            staticNbc.when(() -> NeonBeeConfig.load((Vertx)((Vertx)ArgumentMatchers.any()), (Path)((Path)ArgumentMatchers.any()))).thenReturn((Object)Future.failedFuture((String)"fail starting NeonBee"));
            Launcher.startNeonBee((NeonBeeOptions)options);
            staticNbc.verify(() -> NeonBeeConfig.load((Vertx)((Vertx)ArgumentMatchers.any()), (Path)((Path)Mockito.eq((Object)tempDirectory.resolve("config")))));
        }
    }

    private void assertNeonBeeOptions() {
        NeonBeeOptions neonBeeOptions = this.parseArgs();
        Truth.assertThat((String)neonBeeOptions.getInstanceName()).isEqualTo((Object)"Hodor");
        Truth.assertThat((Integer)neonBeeOptions.getWorkerPoolSize()).isEqualTo((Object)2);
        Truth.assertThat((Integer)neonBeeOptions.getEventLoopPoolSize()).isEqualTo((Object)2);
        Truth.assertThat((Boolean)neonBeeOptions.shouldIgnoreClassPath()).isTrue();
        Truth.assertThat((Boolean)neonBeeOptions.shouldDisableJobScheduling()).isTrue();
        Truth.assertThat((Integer)neonBeeOptions.getServerPort()).isEqualTo((Object)9000);
        Truth.assertThat((Iterable)neonBeeOptions.getModuleJarPaths()).containsExactly(new Object[]{Path.of("path1", new String[0]), Path.of("path2", new String[0]), Path.of("path3", new String[0]), Path.of("path4", new String[0])});
    }

    private void assertClusteredOptions() {
        NeonBeeOptions neonBeeOptions = this.parseArgs();
        Truth.assertThat((Integer)neonBeeOptions.getClusterPort()).isEqualTo((Object)10000);
        Truth.assertThat((Boolean)neonBeeOptions.isClustered()).isTrue();
        Truth.assertThat((Object)neonBeeOptions.getClusterConfig()).isInstanceOf(ClasspathXmlConfig.class);
        ClasspathXmlConfig xmlConfig = (ClasspathXmlConfig)neonBeeOptions.getClusterConfig();
        Truth.assertThat((Integer)xmlConfig.getNetworkConfig().getPort()).isEqualTo((Object)20000);
    }

    private NeonBeeOptions parseArgs() {
        NeonBeeOptions.Mutable options = new NeonBeeOptions.Mutable();
        CLIConfigurator.inject((CommandLine)Launcher.parseCommandLine((String[])this.args), (Object)options);
        return options;
    }
}

