/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.hazelcast.core.LifecycleService;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.NeonBeeOptions;
import io.neonbee.test.helper.OptionsHelper;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeonBeeExtension
implements ParameterResolver,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    public static final int DEFAULT_TIMEOUT_DURATION = 60;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final Logger LOGGER = LoggerFactory.getLogger(NeonBeeExtension.class);
    private static final Set<Class> INJECTABLE_TYPES = Set.of(VertxTestContext.class, NeonBee.class);
    private static final String TEST_CONTEXT_KEY = "NeonBeeTestContext";

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return INJECTABLE_TYPES.contains(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        if (type == NeonBee.class) {
            NeonBeeOptions.Mutable options;
            try {
                options = OptionsHelper.options(parameterContext.findAnnotation(NeonBeeInstanceConfiguration.class));
            }
            catch (RuntimeException e) {
                throw new ParameterResolutionException("Error while finding a free port for server verticle.", (Throwable)e);
            }
            return this.unpack(this.store(extensionContext).getOrComputeIfAbsent((Object)options.getInstanceName(), arg_0 -> this.lambda$resolveParameter$0((NeonBeeOptions)options, arg_0)));
        }
        if (type == VertxTestContext.class) {
            return this.newTestContext(extensionContext);
        }
        throw new IllegalStateException("Looks like the ParameterResolver needs a fix...");
    }

    private Object unpack(Object object) {
        if (object instanceof Supplier) {
            return ((Supplier)object).get();
        }
        return object;
    }

    private VertxTestContext newTestContext(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.store(extensionContext);
        ContextList contexts = (ContextList)store.getOrComputeIfAbsent((Object)TEST_CONTEXT_KEY, key -> new ContextList());
        VertxTestContext newTestContext = new VertxTestContext();
        contexts.add(newTestContext);
        return newTestContext;
    }

    private ExtensionContext.Store store(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{NeonBeeExtension.class, extensionContext}));
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.joinActiveTestContexts(context);
    }

    private void joinActiveTestContexts(ExtensionContext extensionContext) throws Exception {
        if (extensionContext.getExecutionException().isPresent()) {
            return;
        }
        ContextList currentContexts = (ContextList)this.store(extensionContext).remove((Object)TEST_CONTEXT_KEY, ContextList.class);
        if (currentContexts != null) {
            for (VertxTestContext context : currentContexts) {
                Timeout annotation;
                int timeoutDuration = 60;
                TimeUnit timeoutUnit = DEFAULT_TIMEOUT_UNIT;
                Optional testMethod = extensionContext.getTestMethod();
                if (testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestMethod().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                } else if (extensionContext.getRequiredTestClass().isAnnotationPresent(Timeout.class)) {
                    annotation = extensionContext.getRequiredTestClass().getAnnotation(Timeout.class);
                    timeoutDuration = annotation.value();
                    timeoutUnit = annotation.timeUnit();
                }
                if (context.awaitCompletion((long)timeoutDuration, timeoutUnit)) {
                    if (!context.failed()) continue;
                    Throwable throwable = context.causeOfFailure();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                throw new TimeoutException("The test execution timed out. Make sure your asynchronous code includes calls to either VertxTestContext#completeNow(), VertxTestContext#failNow() or Checkpoint#flag()");
            }
        }
        if (extensionContext.getParent().isPresent()) {
            this.joinActiveTestContexts((ExtensionContext)extensionContext.getParent().get());
        }
    }

    private NeonBee createNeonBee(NeonBeeOptions options) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference neonBeeBox = new AtomicReference();
        AtomicReference errorBox = new AtomicReference();
        NeonBee.create((NeonBeeOptions)options).onComplete(ar -> {
            if (ar.succeeded()) {
                neonBeeBox.set((NeonBee)ar.result());
            } else {
                errorBox.set(ar.cause());
            }
            latch.countDown();
        });
        try {
            if (!latch.await(60L, DEFAULT_TIMEOUT_UNIT)) {
                throw new VertxException((Throwable)new TimeoutException("Failed to initialize NeonBee in time"));
            }
        }
        catch (InterruptedException e) {
            throw new VertxException("Got interrupted when initializing NeonBee", (Throwable)e);
        }
        Throwable throwable = (Throwable)errorBox.get();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new VertxException("Could not create NeonBee", throwable);
        }
        return (NeonBee)neonBeeBox.get();
    }

    private ThrowingConsumer<NeonBee> closeNeonBee() {
        return neonBee -> {
            ClusterManager clusterManager;
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference errorBox = new AtomicReference();
            Vertx vertx = neonBee.getVertx();
            if (vertx instanceof VertxImpl && (clusterManager = ((VertxImpl)vertx).getClusterManager()) instanceof HazelcastClusterManager) {
                LifecycleService clusterLifecycleService = ((HazelcastClusterManager)clusterManager).getHazelcastInstance().getLifecycleService();
                Executors.newSingleThreadScheduledExecutor(runnable -> {
                    Thread thread = new Thread(runnable, "neonbee-cluster-terminator");
                    thread.setDaemon(true);
                    return thread;
                }).schedule(() -> {
                    if (clusterLifecycleService.isRunning()) {
                        LOGGER.warn("Forcefully terminating Hazelcast cluster after test");
                    }
                    clusterLifecycleService.terminate();
                }, 10L, TimeUnit.SECONDS);
            }
            neonBee.getVertx().close(ar -> {
                if (ar.failed()) {
                    errorBox.set(ar.cause());
                }
                latch.countDown();
            });
            if (!latch.await(60L, DEFAULT_TIMEOUT_UNIT)) {
                throw new TimeoutException("Closing the Vertx context timed out");
            }
            Throwable throwable = (Throwable)errorBox.get();
            if (throwable != null) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new VertxException(throwable);
            }
        };
    }

    private /* synthetic */ ScopedObject lambda$resolveParameter$0(NeonBeeOptions options, String key) {
        return new ScopedObject<NeonBee>(this.createNeonBee(options), this.closeNeonBee());
    }

    static {
        System.setProperty("logback.configurationFile", Path.of("working_dir/config/logback.xml", new String[0]).toString());
        System.setProperty("hazelcast.logging.type", "slf4j");
    }

    private static class ContextList
    extends ArrayList<VertxTestContext> {
        private static final long serialVersionUID = 6455420559550705670L;

        private ContextList() {
        }
    }

    @FunctionalInterface
    private static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    private static class ScopedObject<T>
    implements Supplier<T>,
    ExtensionContext.Store.CloseableResource {
        private final T object;
        private final ThrowingConsumer<T> cleaner;

        ScopedObject(T object, ThrowingConsumer<T> cleaner) {
            this.object = object;
            this.cleaner = cleaner;
        }

        public void close() throws Throwable {
            this.cleaner.accept(this.object);
        }

        @Override
        public T get() {
            return this.object;
        }
    }
}

