/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.truth.Truth;
import com.hazelcast.core.Hazelcast;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.NeonBeeExtension;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.NeonBeeProfile;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataVerticle;
import io.neonbee.test.helper.DeploymentHelper;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NeonBeeExtension.class})
class NeonBeeExtensionBasedTest {
    NeonBeeExtensionBasedTest() {
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should start with default options / default working directory")
    void testNeonBeeDefault(@NeonBeeInstanceConfiguration NeonBee neonBee) {
        Truth.assertThat((Object)neonBee).isNotNull();
        Truth.assertThat((Iterable)neonBee.getOptions().getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.ALL});
        Truth.assertThat((Boolean)this.isClustered(neonBee)).isFalse();
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Instances with the same name should return the same NeonBee instance")
    void testSameNeonBeeInstance(@NeonBeeInstanceConfiguration(instanceName="node1", activeProfiles={}) NeonBee instance1, @NeonBeeInstanceConfiguration(instanceName="node1", activeProfiles={}) NeonBee instance2) {
        Truth.assertThat((Object)instance1).isSameInstanceAs((Object)instance2);
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should start with CORE profile and deploy CoreDataVerticle")
    void testNeonBeeWithCoreDeployment(@NeonBeeInstanceConfiguration(activeProfiles={NeonBeeProfile.CORE}) NeonBee neonBee, VertxTestContext testContext) {
        Truth.assertThat((Object)neonBee).isNotNull();
        Truth.assertThat((Iterable)neonBee.getOptions().getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.CORE});
        Vertx vertx = neonBee.getVertx();
        vertx.deployVerticle((Verticle)new CoreDataVerticle(), testContext.succeeding(id -> {
            Truth.assertThat((Boolean)DeploymentHelper.isVerticleDeployed(vertx, CoreDataVerticle.class)).isTrue();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should start with NONE profile and deploy CoreDataVerticle manually")
    void testNeonBeeWithNoneDeploymentAndManualDeployment(@NeonBeeInstanceConfiguration(activeProfiles={}) NeonBee neonBee, VertxTestContext testContext) {
        Truth.assertThat((Object)neonBee).isNotNull();
        Truth.assertThat((Iterable)neonBee.getOptions().getActiveProfiles()).isEmpty();
        Vertx vertx = neonBee.getVertx();
        vertx.deployVerticle((Verticle)new CoreDataVerticle(), testContext.succeeding(id -> {
            Truth.assertThat((Boolean)DeploymentHelper.isVerticleDeployed(vertx, CoreDataVerticle.class)).isTrue();
            testContext.completeNow();
        }));
    }

    @Test
    @Timeout(value=20, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="3 NeonBee instances with WEB, CORE and STABLE profiles should be started and join one cluster.")
    void testNeonBeeWithClusters(@NeonBeeInstanceConfiguration(activeProfiles={NeonBeeProfile.WEB}, clustered=true) NeonBee web, @NeonBeeInstanceConfiguration(activeProfiles={NeonBeeProfile.CORE}, clustered=true) NeonBee core, @NeonBeeInstanceConfiguration(activeProfiles={NeonBeeProfile.STABLE}, clustered=true) NeonBee stable) {
        Truth.assertThat((Object)web).isNotNull();
        Truth.assertThat((Iterable)web.getOptions().getActiveProfiles()).contains((Object)NeonBeeProfile.WEB);
        Truth.assertThat((Boolean)web.getVertx().isClustered()).isTrue();
        Truth.assertThat((Boolean)this.isClustered(web)).isTrue();
        Truth.assertThat((Object)core).isNotNull();
        Truth.assertThat((Iterable)core.getOptions().getActiveProfiles()).contains((Object)NeonBeeProfile.CORE);
        Truth.assertThat((Boolean)core.getVertx().isClustered()).isTrue();
        Truth.assertThat((Boolean)this.isClustered(core)).isTrue();
        Truth.assertThat((Object)stable).isNotNull();
        Truth.assertThat((Iterable)stable.getOptions().getActiveProfiles()).contains((Object)NeonBeeProfile.STABLE);
        Truth.assertThat((Boolean)stable.getVertx().isClustered()).isTrue();
        Truth.assertThat((Boolean)this.isClustered(stable)).isTrue();
        Truth.assertThat((Integer)Hazelcast.getAllHazelcastInstances().size()).isAtLeast((Comparable)Integer.valueOf(3));
    }

    private boolean isClustered(NeonBee neonBee) {
        return ((VertxInternal)neonBee.getVertx()).getClusterManager() != null;
    }

    @NeonBeeDeployable(profile=NeonBeeProfile.CORE)
    public static class CoreDataVerticle
    extends DataVerticle<String> {
        private static final String NAME = "CoreDataVerticle";

        public String getName() {
            return NAME;
        }

        public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
            return Future.succeededFuture((Object)"CoreDataResponse");
        }
    }
}

