/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeOptions;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.data.DataQuery;
import io.neonbee.internal.codec.DataQueryMessageCodec;
import io.neonbee.test.helper.OptionsHelper;
import io.vertx.core.Closeable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.file.FileSystem;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.spi.cluster.hazelcast.HazelcastClusterManager;
import java.util.List;
import java.util.function.Supplier;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public final class NeonBeeMockHelper {
    private NeonBeeMockHelper() {
    }

    public static Vertx defaultVertxMock() {
        VertxInternal vertxMock = (VertxInternal)Mockito.mock(VertxInternal.class);
        ((VertxInternal)Mockito.doNothing().when((Object)vertxMock)).addCloseHook((Closeable)ArgumentMatchers.any(Closeable.class));
        Mockito.when((Object)vertxMock.deployVerticle((Verticle)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        Mockito.when((Object)vertxMock.deployVerticle((Verticle)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        Mockito.when((Object)vertxMock.deployVerticle((Class)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        ((VertxInternal)Mockito.doAnswer(invocation -> {
            ((Supplier)invocation.getArgument(0)).get();
            return Future.succeededFuture();
        }).when((Object)vertxMock)).deployVerticle((Supplier)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any());
        Mockito.when((Object)vertxMock.deployVerticle((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        Mockito.when((Object)vertxMock.deployVerticle((String)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        Mockito.when((Object)vertxMock.undeploy((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
        Answer handleAnswer = invocation -> {
            ((Handler)invocation.getArgument(invocation.getArguments().length - 1)).handle((Object)Future.succeededFuture());
            return null;
        };
        ((VertxInternal)Mockito.doAnswer((Answer)handleAnswer).when((Object)vertxMock)).deployVerticle((Verticle)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer((Answer)handleAnswer).when((Object)vertxMock)).deployVerticle((Verticle)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer((Answer)handleAnswer).when((Object)vertxMock)).deployVerticle((Class)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer(invocation -> {
            ((Supplier)invocation.getArgument(0)).get();
            return handleAnswer.answer(invocation);
        }).when((Object)vertxMock)).deployVerticle((Supplier)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer((Answer)handleAnswer).when((Object)vertxMock)).deployVerticle((String)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer((Answer)handleAnswer).when((Object)vertxMock)).deployVerticle((String)ArgumentMatchers.any(), (DeploymentOptions)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer((Answer)handleAnswer).when((Object)vertxMock)).undeploy((String)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        ContextInternal contextMock = (ContextInternal)Mockito.mock(ContextInternal.class);
        Mockito.when((Object)vertxMock.getOrCreateContext()).thenReturn((Object)contextMock);
        Mockito.when((Object)contextMock.deploymentID()).thenReturn((Object)"any-deployment-guid");
        FileSystem fileSystemMock = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)vertxMock.fileSystem()).thenReturn((Object)fileSystemMock);
        Mockito.when((Object)fileSystemMock.exists((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture((Object)true));
        Mockito.when((Object)fileSystemMock.exists((String)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any())).thenAnswer(invocation -> {
            ((Handler)invocation.getArgument(invocation.getArguments().length - 1)).handle((Object)Future.succeededFuture((Object)true));
            return fileSystemMock;
        });
        Mockito.when((Object)fileSystemMock.existsBlocking((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Buffer dummyBuffer = Buffer.buffer((String)"{}");
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture((Object)dummyBuffer));
        Mockito.when((Object)fileSystemMock.readFile((String)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any())).thenAnswer(invocation -> {
            ((Handler)invocation.getArgument(invocation.getArguments().length - 1)).handle((Object)Future.succeededFuture((Object)dummyBuffer));
            return fileSystemMock;
        });
        Mockito.when((Object)fileSystemMock.readFileBlocking((String)ArgumentMatchers.any())).thenReturn((Object)dummyBuffer);
        Mockito.when((Object)fileSystemMock.readDir((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture(List.of()));
        Mockito.when((Object)fileSystemMock.readDir((String)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any(Handler.class))).thenAnswer(invocation -> {
            ((Handler)invocation.getArgument(invocation.getArguments().length - 1)).handle((Object)Future.succeededFuture(List.of()));
            return fileSystemMock;
        });
        Mockito.when((Object)fileSystemMock.readDirBlocking((String)ArgumentMatchers.any())).thenReturn(List.of());
        EventBus eventBusMock = (EventBus)Mockito.mock(EventBus.class);
        Mockito.when((Object)vertxMock.eventBus()).thenReturn((Object)eventBusMock);
        ((VertxInternal)Mockito.doAnswer(NeonBeeMockHelper.timerAnswer(1)).when((Object)vertxMock)).setTimer(ArgumentMatchers.anyLong(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer(NeonBeeMockHelper.timerAnswer(3)).when((Object)vertxMock)).setPeriodic(ArgumentMatchers.anyLong(), (Handler)ArgumentMatchers.any());
        Answer executeHandlerAnswer = invocation -> {
            Promise promise = Promise.promise();
            ((Handler)invocation.getArgument(0)).handle((Object)promise);
            ((Handler)invocation.getArgument(invocation.getArguments().length - 1)).handle((Object)promise.future());
            return null;
        };
        ((VertxInternal)Mockito.doAnswer((Answer)executeHandlerAnswer).when((Object)vertxMock)).executeBlocking((Handler)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (Handler)ArgumentMatchers.any());
        ((VertxInternal)Mockito.doAnswer((Answer)executeHandlerAnswer).when((Object)vertxMock)).executeBlocking((Handler)ArgumentMatchers.any(), (Handler)ArgumentMatchers.any());
        Answer executeFutureAnswer = invocation -> {
            Promise promise = Promise.promise();
            ((Handler)invocation.getArgument(0)).handle((Object)promise);
            return promise.future();
        };
        ((VertxInternal)Mockito.doAnswer((Answer)executeFutureAnswer).when((Object)vertxMock)).executeBlocking((Handler)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        ((VertxInternal)Mockito.doAnswer((Answer)executeFutureAnswer).when((Object)vertxMock)).executeBlocking((Handler)ArgumentMatchers.any());
        return vertxMock;
    }

    private static Answer<?> timerAnswer(int repeat) {
        return invocation -> {
            Handler handler = (Handler)invocation.getArgument(1);
            for (int attempt = 0; attempt < repeat; ++attempt) {
                handler.handle((Object)4711L);
            }
            return null;
        };
    }

    public static Future<NeonBee> createNeonBee(Vertx vertx) {
        return NeonBeeMockHelper.createNeonBee(vertx, null);
    }

    public static Future<NeonBee> createNeonBee(Vertx vertx, NeonBeeOptions options) {
        return NeonBee.create(vertxOptions -> Future.succeededFuture((Object)vertx), (NeonBeeOptions)options, null);
    }

    public static NeonBee registerNeonBeeMock(Vertx vertx) {
        return NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions());
    }

    public static NeonBee registerNeonBeeMock(Vertx vertx, NeonBeeOptions options) {
        return NeonBeeMockHelper.registerNeonBeeMock(vertx, options, new NeonBeeConfig());
    }

    public static NeonBee registerNeonBeeMock(Vertx vertx, NeonBeeConfig config) {
        return NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions(), config);
    }

    public static NeonBee registerNeonBeeMock(Vertx vertx, NeonBeeOptions options, NeonBeeConfig config) {
        try {
            vertx.eventBus().registerDefaultCodec(DataQuery.class, (MessageCodec)new DataQueryMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return new NeonBee(vertx, options, config, new CompositeMeterRegistry(), new HazelcastClusterManager());
    }
}

