/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.truth.Truth;
import com.hazelcast.config.Config;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.test.helper.FileSystemHelper;
import io.vertx.core.VertxOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class NeonBeeOptionsTest {
    NeonBeeOptionsTest() {
    }

    @Test
    @DisplayName(value="should generate an instance name if no instance name is passed")
    void generateNameIfNoIsPassed() {
        Truth.assertThat((String)new NeonBeeOptions.Mutable().getInstanceName()).containsMatch("^NeonBee-.{36}$");
    }

    @Test
    @DisplayName(value="should generate an instance name if null is passed as an instance name")
    void generateNameIfNullIsPassed() {
        Truth.assertThat((String)new NeonBeeOptions.Mutable().setInstanceName(null).getInstanceName()).containsMatch("^NeonBee-.{36}$");
    }

    @Test
    @DisplayName(value="should not generate an instance name if an instance name is passed")
    void usePassedInstanceName() {
        Truth.assertThat((String)new NeonBeeOptions.Mutable().setInstanceName("Hodor").getInstanceName()).isEqualTo((Object)"Hodor");
    }

    @Test
    @DisplayName(value="should throw an error, if passed instance name is empty")
    void checkThatInstanceNameIsNotEmpty() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new NeonBeeOptions.Mutable().setInstanceName(""));
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"instanceName must not be empty");
    }

    @Test
    @DisplayName(value="should throw an error, if working directory is null")
    void checkThatWorkingDirIsNotNull() {
        NullPointerException exception = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> new NeonBeeOptions.Mutable().setWorkingDirectory(null));
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"workingDirectory must not be null");
    }

    @Test
    @DisplayName(value="should resolve working directory subfolders according to the working directory path")
    void checkThatSubfoldersExist() throws IOException {
        Path tempDirPath = FileSystemHelper.createTempDirectory();
        NeonBeeOptions.Mutable opts = new NeonBeeOptions.Mutable().setWorkingDirectory(tempDirPath);
        Truth.assertThat((Object)opts.getLogDirectory()).isEqualTo((Object)tempDirPath.resolve("logs"));
        Truth.assertThat((Object)opts.getConfigDirectory()).isEqualTo((Object)tempDirPath.resolve("config"));
        Truth.assertThat((Object)opts.getModelsDirectory()).isEqualTo((Object)tempDirPath.resolve("models"));
        Truth.assertThat((Object)opts.getModulesDirectory()).isEqualTo((Object)tempDirPath.resolve("modules"));
        FileSystemHelper.deleteRecursiveBlocking(tempDirPath);
    }

    @Test
    @DisplayName(value="should ignore class path if set")
    void shouldIgnoreClassPath() {
        Truth.assertThat((Boolean)new NeonBeeOptions.Mutable().setIgnoreClassPath(true).shouldIgnoreClassPath()).isTrue();
    }

    @Test
    @DisplayName(value="should not schedule jobs if set")
    void shouldDisableJobScheduling() {
        Truth.assertThat((Boolean)new NeonBeeOptions.Mutable().setDisableJobScheduling(true).shouldDisableJobScheduling()).isTrue();
    }

    @Test
    @DisplayName(value="should enable clustered mode if set")
    void shouldEnableClustered() {
        Truth.assertThat((Boolean)new NeonBeeOptions.Mutable().setClustered(true).isClustered()).isTrue();
    }

    @Test
    @DisplayName(value="Test port set correctly")
    void checkClusterPort() {
        Truth.assertThat((Integer)new NeonBeeOptions.Mutable().getClusterPort()).isEqualTo((Object)0);
        Truth.assertThat((Integer)new NeonBeeOptions.Mutable().setClusterPort(10000).getClusterPort()).isEqualTo((Object)10000);
    }

    @Test
    @DisplayName(value="Test server verticle port set correctly")
    void checkServerVerticlePort() {
        Truth.assertThat((Integer)new NeonBeeOptions.Mutable().getServerPort()).isNull();
        Truth.assertThat((Integer)new NeonBeeOptions.Mutable().setServerPort(Integer.valueOf(10000)).getServerPort()).isEqualTo((Object)10000);
    }

    @Test
    @DisplayName(value="Test server profiles set correctly")
    void checkProfiles() {
        NeonBeeOptions.Mutable opts = new NeonBeeOptions.Mutable();
        Truth.assertThat((Iterable)opts.getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.ALL});
        opts = new NeonBeeOptions.Mutable().setActiveProfiles(new String[]{"CORE,WEB"});
        Truth.assertThat((Iterable)opts.getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.CORE, NeonBeeProfile.WEB});
        opts = new NeonBeeOptions.Mutable().setActiveProfiles(List.of(NeonBeeProfile.CORE, NeonBeeProfile.WEB));
        Truth.assertThat((Iterable)opts.getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.CORE, NeonBeeProfile.WEB});
        opts = new NeonBeeOptions.Mutable().setActiveProfiles(new String[0]);
        Truth.assertThat((Iterable)opts.getActiveProfiles()).isEmpty();
        opts = new NeonBeeOptions.Mutable().setActiveProfiles(new String[]{"anything"});
        Truth.assertThat((Iterable)opts.getActiveProfiles()).isEmpty();
        opts = new NeonBeeOptions.Mutable().setActiveProfiles(List.of(NeonBeeProfile.CORE, NeonBeeProfile.WEB, NeonBeeProfile.WEB, NeonBeeProfile.CORE));
        Truth.assertThat((Iterable)opts.getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.CORE, NeonBeeProfile.WEB});
        Set profiles = opts.getActiveProfiles();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> profiles.add(NeonBeeProfile.WEB));
        opts.addActiveProfile(NeonBeeProfile.ALL).addActiveProfile(NeonBeeProfile.ALL);
        opts.addActiveProfiles(new NeonBeeProfile[]{NeonBeeProfile.CORE, NeonBeeProfile.ALL});
        Truth.assertThat((Iterable)opts.getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.CORE, NeonBeeProfile.WEB, NeonBeeProfile.ALL});
        opts.removeActiveProfile(NeonBeeProfile.CORE).removeActiveProfile(NeonBeeProfile.CORE).removeActiveProfile(NeonBeeProfile.WEB);
        opts.removeActiveProfiles(new NeonBeeProfile[]{NeonBeeProfile.WEB, NeonBeeProfile.CORE});
        Truth.assertThat((Iterable)opts.getActiveProfiles()).containsExactly(new Object[]{NeonBeeProfile.ALL});
        opts.clearActiveProfiles();
        Truth.assertThat((Iterable)opts.getActiveProfiles()).isEmpty();
    }

    @Test
    @DisplayName(value="Test event loop pool size getter and setter")
    void testEventLoopPoolSizeGetterSetter() {
        NeonBeeOptions.Mutable mutable = new NeonBeeOptions.Mutable();
        Truth.assertThat((Integer)mutable.getEventLoopPoolSize()).isEqualTo((Object)VertxOptions.DEFAULT_EVENT_LOOP_POOL_SIZE);
        Truth.assertThat((Integer)mutable.setEventLoopPoolSize(10000).getEventLoopPoolSize()).isEqualTo((Object)10000);
    }

    @Test
    @DisplayName(value="should throw an error, if event loop pool size is less then 1")
    void checkThatEventLoopPoolSizeIsIsAtLeastOne() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new NeonBeeOptions.Mutable().setEventLoopPoolSize(0));
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"eventLoopSize must be > 0");
    }

    @Test
    @DisplayName(value="Test worker pool size getter and setter")
    void testWorkerPoolSizeGetterSetter() {
        NeonBeeOptions.Mutable mutable = new NeonBeeOptions.Mutable();
        Truth.assertThat((Integer)mutable.getWorkerPoolSize()).isEqualTo((Object)20);
        Truth.assertThat((Integer)mutable.setWorkerPoolSize(10000).getWorkerPoolSize()).isEqualTo((Object)10000);
    }

    @Test
    @DisplayName(value="should throw an error, if worker pool size is less then 1")
    void checkThatWorkerPoolSizeIsIsAtLeastOne() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new NeonBeeOptions.Mutable().setWorkerPoolSize(0));
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"workerPoolSize must be > 0");
    }

    @Test
    @DisplayName(value="Test clusterConfig getter and setter")
    void testClusterConfig() {
        NeonBeeOptions.Mutable mutable = new NeonBeeOptions.Mutable();
        Config defaultConfig = mutable.getClusterConfig();
        Truth.assertThat((Integer)defaultConfig.getNetworkConfig().getPort()).isEqualTo((Object)50000);
        mutable.setClusterConfigResource("hazelcast-local.xml");
        Config localConfig = mutable.getClusterConfig();
        Truth.assertThat((Integer)localConfig.getNetworkConfig().getPort()).isEqualTo((Object)20000);
        mutable = new NeonBeeOptions.Mutable().setClusterConfig(localConfig);
        Truth.assertThat((Integer)mutable.getClusterConfig().getNetworkConfig().getPort()).isEqualTo((Object)20000);
    }

    @Test
    @DisplayName(value="Test moduleJarPaths getter and setter")
    void testModuleJarPath() {
        NeonBeeOptions.Mutable mutable = new NeonBeeOptions.Mutable();
        Truth.assertThat((Iterable)mutable.getModuleJarPaths()).isEmpty();
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(Path.of("a", new String[0]));
        paths.add(Path.of("b", new String[0]));
        Truth.assertThat((Object)mutable.setModuleJarPaths(paths)).isSameInstanceAs((Object)mutable);
        Truth.assertThat((Iterable)mutable.getModuleJarPaths()).isNotSameInstanceAs(paths);
        Truth.assertThat((Iterable)mutable.getModuleJarPaths()).containsExactly(new Object[]{Path.of("a", new String[0]), Path.of("b", new String[0])});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> mutable.getModuleJarPaths().add(Path.of("c", new String[0])));
        Truth.assertThat((Iterable)mutable.setModuleJarPaths(new String[]{"e", "f"}).getModuleJarPaths()).containsExactly(new Object[]{Path.of("e", new String[0]), Path.of("f", new String[0])});
        Truth.assertThat((Iterable)mutable.setModuleJarPaths(new String[]{"g" + File.pathSeparator + "h", "i" + File.pathSeparator + "j" + File.separator + "k"}).getModuleJarPaths()).containsExactly(new Object[]{Path.of("g", new String[0]), Path.of("h", new String[0]), Path.of("i", new String[0]), Path.of("j" + File.separator + "k", new String[0])});
    }
}

