/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.NeonBeeExtensionBasedTest;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.health.DummyHealthCheckProvider;
import io.neonbee.health.HealthCheckProvider;
import io.neonbee.health.HealthCheckRegistry;
import io.neonbee.internal.NeonBeeModuleJar;
import io.neonbee.internal.tracking.MessageDirection;
import io.neonbee.internal.tracking.TrackingDataLoggingStrategy;
import io.neonbee.internal.tracking.TrackingInterceptor;
import io.neonbee.internal.verticle.ConsolidationVerticle;
import io.neonbee.internal.verticle.HealthCheckVerticle;
import io.neonbee.internal.verticle.LoggerManagerVerticle;
import io.neonbee.internal.verticle.MetricsVerticle;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.OptionsHelper;
import io.neonbee.test.helper.ResourceHelper;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class NeonBeeTest
extends NeonBeeTestBase {
    private Vertx vertx;

    NeonBeeTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
        switch (((Method)testInfo.getTestMethod().get()).getName()) {
            case "testDeployCoreVerticlesFromClassPath": {
                options.addActiveProfile(NeonBeeProfile.CORE);
                options.setIgnoreClassPath(false);
                break;
            }
            case "testRegisterClusterHealthChecks": {
                options.setClustered(true);
                options.setClusterConfigResource("hazelcast-local.xml");
                break;
            }
            case "testDeployModule": {
                try {
                    options.setModuleJarPaths(List.of(NeonBeeModuleJar.create("testmodule").withVerticles().build().writeToTempPath()));
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @AfterEach
    void closeVertx(VertxTestContext testContext) {
        if (this.vertx != null) {
            this.vertx.close().onComplete(testContext.succeedingThenComplete());
            this.vertx = null;
        } else {
            testContext.completeNow();
        }
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        switch (testInfo.getTestMethod().map(Method::getName).orElse("")) {
            case "testStartWithNoWorkingDirectory": {
                return WorkingDirectoryBuilder.none();
            }
            case "testStartWithEmptyWorkingDirectory": {
                return WorkingDirectoryBuilder.empty();
            }
        }
        return super.provideWorkingDirectoryBuilder(testInfo, testContext);
    }

    @Test
    @Timeout(value=4, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should start with default options / default working directory")
    void testStart(Vertx vertx) {
        Truth.assertThat((Object)this.getNeonBee()).isNotNull();
        Truth.assertThat((Object)NeonBee.get((Vertx)vertx)).isNotNull();
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should deploy all system verticles")
    void testDeploySystemVerticles(Vertx vertx) {
        Truth.assertThat(NeonBeeTest.getDeployedVerticles(vertx)).containsExactly(new Object[]{MetricsVerticle.class, ConsolidationVerticle.class, LoggerManagerVerticle.class, HealthCheckVerticle.class});
    }

    @Test
    @Timeout(value=30, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should deploy class path verticles (from NeonBeeExtensionBasedTest)")
    void testDeployCoreVerticlesFromClassPath(Vertx vertx) {
        Truth.assertThat(NeonBeeTest.getDeployedVerticles(vertx)).contains(NeonBeeExtensionBasedTest.CoreDataVerticle.class);
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should deploy module JAR")
    void testDeployModule(Vertx vertx) {
        Truth8.assertThat(NeonBeeTest.getDeployedVerticles(vertx).stream().map(Class::getName)).containsAtLeast((Object)"ClassA", (Object)"ClassB", new Object[0]);
    }

    private static Set<Class<? extends Verticle>> getDeployedVerticles(Vertx vertx) {
        return vertx.deploymentIDs().stream().map(arg_0 -> ((VertxInternal)((VertxInternal)vertx)).getDeployment(arg_0)).map(Deployment::getVerticles).flatMap(Collection::stream).map(Object::getClass).collect(Collectors.toSet());
    }

    @Test
    @Disabled(value="If the working dir is deleted, it's not possible to override the HttpServerDefaultPort ...")
    @Timeout(value=4, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should start with no working directory and create the working directory")
    void testStartWithNoWorkingDirectory() {
        Truth.assertThat((Boolean)Files.isDirectory(this.getNeonBee().getOptions().getWorkingDirectory(), new LinkOption[0])).isTrue();
    }

    @Test
    @Disabled(value="If the working dir is empty, it's not possible to override the HttpServerDefaultPort ...")
    @Timeout(value=4, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should start with an empty working directory and create the logs directory")
    void testStartWithEmptyWorkingDirectory() {
        Truth.assertThat((Boolean)Files.isDirectory(this.getNeonBee().getOptions().getLogDirectory(), new LinkOption[0])).isTrue();
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Vert.x should start in non-clustered mode. ")
    void testStandaloneInitialization(VertxTestContext testContext) {
        NeonBee.newVertx((VertxOptions)new VertxOptions(), (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles()).onComplete(testContext.succeeding(vertx -> testContext.verify(() -> {
            this.vertx = vertx;
            Truth.assertThat((Boolean)this.vertx.isClustered()).isFalse();
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Vert.x should start in clustered mode.")
    void testClusterInitialization(VertxTestContext testContext) {
        NeonBee.newVertx((VertxOptions)new VertxOptions(), (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles().setClustered(true).setClusterConfigResource("hazelcast-local.xml")).onComplete(testContext.succeeding(vertx -> testContext.verify(() -> {
            this.vertx = vertx;
            Truth.assertThat((Boolean)this.vertx.isClustered()).isTrue();
            testContext.completeNow();
        })));
    }

    @Test
    @DisplayName(value="NeonBee should register and unregister local consumer correct.")
    void testRegisterAndUnregisterLocalConsumer() {
        String address = "DataVerticle1";
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(address)).isFalse();
        this.getNeonBee().registerLocalConsumer(address);
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(address)).isTrue();
        this.getNeonBee().unregisterLocalConsumer(address);
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(address)).isFalse();
    }

    @Test
    @DisplayName(value="NeonBee should register all default health checks")
    void testRegisterDefaultHealthChecks() {
        Map registeredChecks = this.getNeonBee().getHealthCheckRegistry().getHealthChecks();
        Truth.assertThat((Integer)registeredChecks.size()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)registeredChecks.containsKey("node." + this.getNeonBee().getNodeId() + ".os.memory")).isTrue();
    }

    @Test
    @DisplayName(value="NeonBee should register all cluster + default health checks if started clustered")
    void testRegisterClusterHealthChecks() {
        Map registeredChecks = this.getNeonBee().getHealthCheckRegistry().getHealthChecks();
        Truth.assertThat((Integer)registeredChecks.size()).isEqualTo((Object)2);
        Truth.assertThat((Boolean)registeredChecks.containsKey("cluster.hazelcast")).isTrue();
    }

    @Test
    @Timeout(value=1, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="NeonBee should register all SPI-provided + default health checks")
    void testRegisterSpiAndDefaultHealthChecks(VertxTestContext testContext) {
        HealthCheckRegistry registry = this.getNeonBee().getHealthCheckRegistry();
        Set healthCheckMap = registry.getHealthChecks().keySet();
        for (String checkId : healthCheckMap) {
            registry.unregister(checkId);
        }
        this.runWithMetaInfService(HealthCheckProvider.class, DummyHealthCheckProvider.class.getName(), testContext, () -> this.getNeonBee().registerHealthChecks().onComplete(testContext.succeeding(v -> testContext.verify(() -> {
            Map registeredChecks = registry.getHealthChecks();
            Truth.assertThat((Integer)registeredChecks.size()).isEqualTo((Object)2);
            Truth.assertThat((Boolean)registeredChecks.containsKey("node." + this.getNeonBee().getNodeId() + ".os.memory")).isTrue();
            Truth.assertThat((Boolean)registeredChecks.containsKey("dummy")).isTrue();
            testContext.completeNow();
        }))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithMetaInfService(Class<?> service, String content, VertxTestContext context, Runnable runnable) {
        URLClassLoader classLoader;
        Path providerPath = ResourceHelper.TEST_RESOURCES.resolve("META-INF/services/" + service.getName());
        try {
            Files.write(providerPath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            classLoader = new URLClassLoader(new URL[]{ResourceHelper.TEST_RESOURCES.resolve(".").toUri().toURL()});
        }
        catch (IOException e) {
            context.failNow((Throwable)e);
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            runnable.run();
        }
        finally {
            thread.setContextClassLoader(original);
            try {
                Files.deleteIfExists(providerPath);
            }
            catch (IOException e) {
                context.failNow((Throwable)e);
            }
        }
    }

    @Test
    @DisplayName(value="NeonBee should have a (unique) node id")
    void testGetNodeId() {
        Truth.assertThat((String)this.getNeonBee().getNodeId()).matches(Pattern.compile("[0-9a-zA-Z\\-]+"));
    }

    @Test
    @DisplayName(value="Vert.x should add eventbus interceptors.")
    void testDecorateEventbus() {
        Vertx vertx = NeonBeeMockHelper.defaultVertxMock();
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, new NeonBeeConfig(new JsonObject().put("trackingDataHandlingStrategy", (Object)"wrongvalue")));
        EventBus eventBus = (EventBus)Mockito.mock(EventBus.class);
        Mockito.when((Object)vertx.eventBus()).thenReturn((Object)eventBus);
        Mockito.when((Object)eventBus.addInboundInterceptor((Handler)Mockito.any(Handler.class))).thenReturn((Object)eventBus);
        Mockito.when((Object)eventBus.addOutboundInterceptor((Handler)Mockito.any(Handler.class))).thenReturn((Object)eventBus);
        ArgumentCaptor inboundHandlerCaptor = ArgumentCaptor.forClass(Handler.class);
        ArgumentCaptor outboundHandlerCaptor = ArgumentCaptor.forClass(Handler.class);
        neonBee.decorateEventBus();
        ((EventBus)Mockito.verify((Object)eventBus)).addInboundInterceptor((Handler)inboundHandlerCaptor.capture());
        ((EventBus)Mockito.verify((Object)eventBus)).addOutboundInterceptor((Handler)outboundHandlerCaptor.capture());
        TrackingInterceptor inboundHandler = (TrackingInterceptor)inboundHandlerCaptor.getValue();
        TrackingInterceptor outboundHandler = (TrackingInterceptor)outboundHandlerCaptor.getValue();
        Truth.assertThat((Comparable)inboundHandler.getDirection()).isEqualTo((Object)MessageDirection.INBOUND);
        Truth.assertThat(TrackingDataLoggingStrategy.class).isAssignableTo(inboundHandler.getHandler().getClass());
        Truth.assertThat((Comparable)outboundHandler.getDirection()).isEqualTo((Object)MessageDirection.OUTBOUND);
        Truth.assertThat(TrackingDataLoggingStrategy.class).isAssignableTo(outboundHandler.getHandler().getClass());
    }

    @Test
    void testFilterByProfile() {
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(CoreVerticle.class, List.of(NeonBeeProfile.CORE))).isTrue();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(CoreVerticle.class, List.of(NeonBeeProfile.CORE, NeonBeeProfile.STABLE))).isTrue();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(CoreVerticle.class, List.of(NeonBeeProfile.STABLE))).isFalse();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(StableVerticle.class, List.of(NeonBeeProfile.STABLE))).isTrue();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(StableVerticle.class, List.of(NeonBeeProfile.STABLE, NeonBeeProfile.CORE))).isTrue();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(IncubatorVerticle.class, List.of(NeonBeeProfile.INCUBATOR))).isTrue();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(SystemVerticle.class, List.of(NeonBeeProfile.CORE))).isFalse();
        Truth.assertThat((Boolean)NeonBee.filterByAutoDeployAndProfiles(SystemVerticle.class, List.of(NeonBeeProfile.ALL))).isFalse();
    }

    static Stream<Arguments> arguments() {
        Arguments one = Arguments.of((Object[])new Object[]{"fail the boot, but close Vert.x fine and ensure a Vert.x that is NOT owned by the outside is closed", true, Future.succeededFuture()});
        Arguments two = Arguments.of((Object[])new Object[]{"fail the boot and assure that Vert.x is not closed for an instance that is provided from the outside", false, Future.succeededFuture()});
        Arguments three = Arguments.of((Object[])new Object[]{"fail the boot and also the Vert.x close", true, Future.failedFuture((String)"ANY FAILURE!!")});
        return Stream.of(one, two, three);
    }

    @ParameterizedTest(name="{index}: {0}")
    @MethodSource(value={"arguments"})
    @Timeout(timeUnit=TimeUnit.SECONDS, value=10)
    @DisplayName(value="NeonBee should close only self-owned Vert.x instances if boot fails")
    void checkTestCloseVertxOnError(String description, boolean ownVertx, Future<Void> result, VertxTestContext testContext) {
        try (MockedStatic mocked = Mockito.mockStatic(NeonBee.class);){
            mocked.when(() -> NeonBee.loadConfig((Vertx)((Vertx)ArgumentMatchers.any()), (Path)((Path)ArgumentMatchers.any()))).thenReturn((Object)Future.failedFuture((Throwable)new RuntimeException("Failing Vert.x!")));
            mocked.when(() -> NeonBee.create((Function)((Function)ArgumentMatchers.any()), (NeonBeeOptions)((NeonBeeOptions)ArgumentMatchers.any()), (NeonBeeConfig)((NeonBeeConfig)ArgumentMatchers.any()))).thenCallRealMethod();
            Vertx failingVertxMock = (Vertx)Mockito.mock(Vertx.class);
            Mockito.when((Object)failingVertxMock.close()).thenReturn(result);
            Object vertxFunction = ownVertx ? vertxOptions -> Future.succeededFuture((Object)failingVertxMock) : vertxOptions -> Future.succeededFuture((Object)failingVertxMock);
            NeonBee.create((Function)vertxFunction, (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles(), null).onComplete(testContext.failing(throwable -> testContext.verify(() -> {
                Truth.assertThat((String)throwable.getMessage()).isEqualTo((Object)"Failing Vert.x!");
                ((Vertx)Mockito.verify((Object)failingVertxMock, (VerificationMode)Mockito.times((int)(ownVertx ? 1 : 0)))).close();
                testContext.completeNow();
            })));
        }
    }

    @NeonBeeDeployable(profile=NeonBeeProfile.CORE)
    private static class CoreVerticle
    extends AbstractVerticle {
        private CoreVerticle() {
        }
    }

    @NeonBeeDeployable(profile=NeonBeeProfile.STABLE)
    private static class StableVerticle
    extends AbstractVerticle {
        private StableVerticle() {
        }
    }

    @NeonBeeDeployable(profile=NeonBeeProfile.INCUBATOR)
    private static class IncubatorVerticle
    extends AbstractVerticle {
        private IncubatorVerticle() {
        }
    }

    @NeonBeeDeployable(profile=NeonBeeProfile.CORE, autoDeploy=false)
    private static class SystemVerticle
    extends AbstractVerticle {
        private SystemVerticle() {
        }
    }
}

