/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.cluster;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeExtension;
import io.neonbee.NeonBeeInstanceConfiguration;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.data.internal.DataContextImpl;
import io.neonbee.test.helper.DeploymentHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NeonBeeExtension.class})
class LocalRequestClusterTest {
    private static final DataVerticle<JsonObject> LOCAL_TARGET_VERTICLE = new DataVerticle<JsonObject>(){

        public String getName() {
            return "LocalTarget";
        }

        public Future<JsonObject> retrieveData(DataQuery query, DataMap dataMap, DataContext context) {
            return Future.succeededFuture((Object)new JsonObject().put("name", (Object)"Duke"));
        }
    };

    LocalRequestClusterTest() {
    }

    @Test
    @Timeout(value=10, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Test that setLocalOnly works as expected")
    void testLocalRequest(@NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee source, @NeonBeeInstanceConfiguration(clustered=true, activeProfiles={}) NeonBee target, VertxTestContext testContext) {
        Checkpoint nonLocalRequest = testContext.checkpoint();
        Checkpoint localRequest = testContext.checkpoint();
        DeploymentHelper.deployVerticle(target.getVertx(), LOCAL_TARGET_VERTICLE).compose(s -> {
            DataRequest request = new DataRequest(LOCAL_TARGET_VERTICLE.getName());
            return DataVerticle.requestData((Vertx)source.getVertx(), (DataRequest)request, (DataContext)new DataContextImpl());
        }).compose(response -> {
            testContext.verify(() -> {
                Truth.assertThat((String)response.getString("name")).isEqualTo((Object)"Duke");
                nonLocalRequest.flag();
            });
            DataRequest request = new DataRequest(LOCAL_TARGET_VERTICLE.getName()).setLocalOnly(true);
            return DataVerticle.requestData((Vertx)source.getVertx(), (DataRequest)request, (DataContext)new DataContextImpl());
        }).onComplete(testContext.failing(e -> testContext.verify(() -> {
            Truth.assertThat((Throwable)e).isInstanceOf(DataException.class);
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"No handlers for address");
            Truth.assertThat((Integer)((DataException)e).failureCode()).isEqualTo((Object)1010);
            localRequest.flag();
        })));
    }
}

