/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import com.google.common.truth.Truth;
import io.neonbee.data.DataAction;
import io.neonbee.data.DataQuery;
import io.vertx.core.buffer.Buffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class DataQueryTest {
    private DataQuery query;

    DataQueryTest() {
    }

    @BeforeEach
    void setUp() {
        this.query = new DataQuery();
    }

    @Test
    @DisplayName(value="setQuery should set a query and reset parameters to null")
    void testSetQuery() {
        this.query.parameters = Collections.emptyMap();
        this.query.setQuery("name=Hodor");
        Truth.assertThat((String)this.query.getQuery()).isEqualTo((Object)"name=Hodor");
        Truth.assertThat((Map)this.query.parameters).isNotNull();
    }

    @Test
    @DisplayName(value="getQuery should return the parameters joined to a String if parameters is non null")
    void testGetQuery2() {
        this.query.parameters = Map.of("Hodor", List.of("Hodor"));
        Truth.assertThat((String)this.query.getQuery()).isEqualTo((Object)"Hodor=Hodor");
        this.query.parameters = Map.of("Hodor", List.of("Hodor", "Hodor2"));
        Truth.assertThat((String)this.query.getQuery()).isEqualTo((Object)"Hodor=Hodor&Hodor=Hodor2");
    }

    @Test
    @DisplayName(value="getParameters should return a Map with the query parameters")
    void testGetParameters() {
        this.query.setQuery("Hodor=Hodor&Jon=Snow&Hodor=Hodor2");
        Map<String, List<String>> expected = Map.of("Hodor", List.of("Hodor", "Hodor2"), "Jon", List.of("Snow"));
        Truth.assertThat((Map)this.query.getParameters()).containsExactlyEntriesIn(expected);
    }

    @Test
    @DisplayName(value="getParameterValues should return a List with the values for a given parameter")
    void testGetParameterValues() {
        this.query.setQuery("Hodor=Hodor&Jon=Snow&Hodor=Hodor2");
        List<String> expected = List.of("Hodor", "Hodor2");
        Truth.assertThat((Iterable)this.query.getParameterValues("Hodor")).containsExactlyElementsIn(expected);
    }

    @Test
    @DisplayName(value="getParameter should return the value for a given parameter")
    void testGetParameter() {
        this.query.setQuery("Hodor=Hodor&Jon=Snow&Hodor=Hodor2&Some=Data&Empty=&AlsoEmpty&Test=123");
        Truth.assertThat((String)this.query.getParameter("Hodor")).isEqualTo((Object)"Hodor");
        Truth.assertThat((String)this.query.getParameter("Jon")).isEqualTo((Object)"Snow");
        Truth.assertThat((String)this.query.getParameter("Some")).isEqualTo((Object)"Data");
        Truth.assertThat((String)this.query.getParameter("Empty")).isEqualTo((Object)"");
        Truth.assertThat((String)this.query.getParameter("AlsoEmpty")).isEqualTo((Object)"");
        Truth.assertThat((String)this.query.getParameter("Test")).isEqualTo((Object)"123");
    }

    @Test
    @DisplayName(value="getParameter should return the first value for a given parameter")
    void testGetFirstParameter() {
        this.query.setQuery("Hodor=Hodor&Jon=Snow&Hodor=Hodor2");
        String expected = "Hodor";
        Truth.assertThat((String)this.query.getParameter("Hodor")).isEqualTo((Object)expected);
    }

    @Test
    @DisplayName(value="addParameter should add a given parameter with value(s)")
    void testAddParameter() {
        Map<String, List<String>> expected = Map.of("Jon", List.of("Snow"));
        Truth.assertThat((Map)this.query.addParameter((String)"Jon", (String[])new String[]{"Snow"}).parameters).isEqualTo(expected);
        expected = Map.of("Hodor", List.of("Hodor", "Hodor2"), "Jon", List.of("Snow"));
        Truth.assertThat((Map)this.query.addParameter((String)"Hodor", (String[])new String[]{"Hodor", "Hodor2"}).parameters).isEqualTo(expected);
    }

    @Test
    @DisplayName(value="setParameter should set a given parameter with value(s)")
    void testSetParameter() {
        Map<String, List<String>> expected = Map.of("Jon", List.of("Snow"));
        Truth.assertThat((Map)this.query.setParameter((String)"Jon", (String[])new String[]{"Snow"}).parameters).isEqualTo(expected);
        expected = Map.of("Hodor", List.of("Hodor", "Hodor2"), "Jon", List.of("Snow"));
        Truth.assertThat((Map)this.query.setParameter((String)"Hodor", (String[])new String[]{"Hodor", "Hodor2"}).parameters).isEqualTo(expected);
        expected = Map.of("Hodor", List.of("Hodor", "Hodor2"), "Jon", List.of("Snow", "Know", "Nothing"));
        Truth.assertThat((Map)this.query.setParameter((String)"Jon", (String[])new String[]{"Snow", "Know", "Nothing"}).parameters).isEqualTo(expected);
    }

    @Test
    @DisplayName(value="setParameter should set a given parameter with value(s)")
    void testRemoveParameter() {
        this.query.parameters = Map.of("Hodor", List.of("Hodor", "Hodor2"), "Jon", List.of("Snow", "Know", "Nothing"));
        this.query.setQuery(this.query.getQuery());
        Map<String, List<String>> expected = Map.of("Hodor", List.of("Hodor", "Hodor2"));
        Truth.assertThat((Map)this.query.removeParameter((String)"Jon").parameters).isEqualTo(expected);
    }

    @Test
    @DisplayName(value="parseQueryString should parse a query string correct")
    void testParseQueryString() {
        Map<String, List<String>> expected = Map.of("Hodor", List.of(""));
        Truth.assertThat((Map)DataQuery.parseQueryString((String)"Hodor")).containsExactlyEntriesIn(expected);
        Truth.assertThat((Map)DataQuery.parseQueryString((String)"Hodor=")).containsExactlyEntriesIn(expected);
        expected = Map.of("Hodor", List.of("Hodor"));
        Truth.assertThat((Map)DataQuery.parseQueryString((String)"Hodor=Hodor")).containsExactlyEntriesIn(expected);
        expected = Map.of("Hodor", List.of("Hodor", "Hodor2"));
        Truth.assertThat((Map)DataQuery.parseQueryString((String)"Hodor=Hodor&Hodor=Hodor2")).containsExactlyEntriesIn(expected);
        expected = Map.of("Hodor", List.of("Hodor", "Hodor2"), "Jon", List.of("Snow"));
        Truth.assertThat((Map)DataQuery.parseQueryString((String)"Hodor=Hodor&Jon=Snow&Hodor=Hodor2")).containsExactlyEntriesIn(expected);
    }

    @Test
    @DisplayName(value="setUriPath should not work if it contains a query")
    void testSetUriPathWithQuery() {
        Exception thrownException = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new DataQuery().setUriPath("/raw/MyDataVerticle?param=value"));
        Truth.assertThat((String)thrownException.getMessage()).isEqualTo((Object)"uriPath must not contain a query");
    }

    @Test
    @DisplayName(value="DataQuery creation should not work if it uriPath contains a query")
    void testDataQueryCreation() {
        Exception thrownException = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new DataQuery("/odata/MyNamespace.MyService/MyEntitySet?$param=value"));
        Truth.assertThat((String)thrownException.getMessage()).isEqualTo((Object)"uriPath must not contain a query");
    }

    @Test
    @DisplayName(value="DataQuery should have empty map when no header is passed")
    void testEmptyHeader() {
        DataQuery query = new DataQuery("uri", "name=Hodor");
        Truth.assertThat((Map)query.getHeaders()).isEqualTo(Map.of());
    }

    @Test
    @DisplayName(value="Equals should return false with different bodies")
    void testEqualsWithDifferentBodies() {
        DataQuery query1 = new DataQuery(DataAction.CREATE, "uri", "name=Hodor", Map.of("header1", List.of("value1")), Buffer.buffer((String)"payload1"));
        Truth.assertThat((Object)query1.copy().setBody(Buffer.buffer((String)"payload2"))).isNotEqualTo((Object)query1);
    }
}

