/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.data;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeDeployable;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.config.MetricsConfig;
import io.neonbee.data.DataContext;
import io.neonbee.data.DataException;
import io.neonbee.data.DataMap;
import io.neonbee.data.DataQuery;
import io.neonbee.data.DataRequest;
import io.neonbee.data.DataVerticle;
import io.neonbee.test.base.DataVerticleTestBase;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class DataVerticleTest
extends DataVerticleTestBase {
    private DataVerticleImpl0 dataVerticleImpl0;
    private DataVerticleImpl1 dataVerticleImpl1;
    private DataVerticleImpl2 dataVerticleImpl2;

    DataVerticleTest() {
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @BeforeEach
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void deployEntityVerticles(VertxTestContext testContext) {
        Checkpoint checkpoint = testContext.checkpoint(3);
        this.dataVerticleImpl0 = new DataVerticleImpl0();
        this.deployVerticle((Verticle)this.dataVerticleImpl0).onComplete(testContext.succeeding(result -> checkpoint.flag()));
        this.dataVerticleImpl1 = new DataVerticleImpl1();
        this.deployVerticle((Verticle)this.dataVerticleImpl1).onComplete(testContext.succeeding(result -> checkpoint.flag()));
        this.dataVerticleImpl2 = new DataVerticleImpl2();
        this.deployVerticle((Verticle)this.dataVerticleImpl2).onComplete(testContext.succeeding(result -> checkpoint.flag()));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Ensure that start() from AbstractVerticle is called")
    void ensureStartMethodIsCalled(final VertxTestContext testContext) {
        DataVerticle<Void> verticle = new DataVerticle<Void>(){

            public void start() throws Exception {
                testContext.completeNow();
            }

            public String getName() {
                return "NAME";
            }
        };
        this.deployVerticle((Verticle)verticle);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Get the correct namespace for verticle with and without the @NeonBeeDeployable annotation")
    void testGetNamespace() {
        Truth.assertThat((String)this.dataVerticleImpl0.getNamespace()).isNull();
        Truth.assertThat((String)this.dataVerticleImpl1.getNamespace()).isNull();
        Truth.assertThat((String)this.dataVerticleImpl2.getNamespace()).isEqualTo((Object)"DataVerticleTestNamespace2".toLowerCase(Locale.ENGLISH));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check if DataVerticle is registered with the correct qualifiedName (address)")
    void registerEventbusTest(VertxTestContext testContext) {
        String addressDVImpl2 = "DataVerticleTestNamespace2".toLowerCase(Locale.ENGLISH) + "/ExpectedName2";
        DataRequest requestDVImpl2 = new DataRequest(addressDVImpl2, new DataQuery().addParameter("ping", new String[]{""}));
        Checkpoint checkpoint = testContext.checkpoint(3);
        this.assertDataEquals(this.requestData("ExpectedName0"), "Hello, I am ExpectedName0", testContext).onComplete(testContext.succeeding(nothing -> checkpoint.flag()));
        this.assertDataEquals(this.requestData("ExpectedName1"), "Hello, I am ExpectedName1", testContext).onComplete(testContext.succeeding(nothing -> checkpoint.flag()));
        this.assertDataFailure(this.requestData(requestDVImpl2), new DataException(400, "Bad Request"), testContext).onComplete(testContext.succeeding(nothing -> checkpoint.flag()));
    }

    @Test
    @DisplayName(value="Check if DataVerticle registers itself as local consumer on deployment")
    void registerLocalConsumerTest() {
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(this.dataVerticleImpl0.getAddress())).isTrue();
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(this.dataVerticleImpl1.getAddress())).isTrue();
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(this.dataVerticleImpl2.getAddress())).isTrue();
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="Check if DataVerticle unregisters itself as local consumer on undeployment")
    void unregisterLocalConsumerTest(VertxTestContext testContext) {
        Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(this.dataVerticleImpl0.getAddress())).isTrue();
        this.undeployVerticles(DataVerticleImpl0.class).onComplete(testContext.succeeding(v -> testContext.verify(() -> {
            Truth.assertThat((Boolean)this.getNeonBee().isLocalConsumerAvailable(this.dataVerticleImpl0.getAddress())).isFalse();
            testContext.completeNow();
        })));
    }

    @Test
    void createQualifiedName() {
        Truth.assertThat((String)DataVerticle.createQualifiedName((String)"namespace", (String)"verticle")).isEqualTo((Object)"namespace/verticle");
        Truth.assertThat((String)DataVerticle.createQualifiedName((String)"nameSpace", (String)"verticle")).isEqualTo((Object)"namespace/verticle");
    }

    static Stream<Arguments> metricsConfigurationArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, VerticleMetricsConfigTestValues.NULL, false}), Arguments.of((Object[])new Object[]{false, VerticleMetricsConfigTestValues.FALSE, false}), Arguments.of((Object[])new Object[]{false, VerticleMetricsConfigTestValues.TRUE, false}), Arguments.of((Object[])new Object[]{false, VerticleMetricsConfigTestValues.CONFIG_NULL, false}), Arguments.of((Object[])new Object[]{true, VerticleMetricsConfigTestValues.FALSE, false}), Arguments.of((Object[])new Object[]{true, VerticleMetricsConfigTestValues.NULL, true}), Arguments.of((Object[])new Object[]{true, VerticleMetricsConfigTestValues.TRUE, true}), Arguments.of((Object[])new Object[]{true, VerticleMetricsConfigTestValues.CONFIG_NULL, true}), Arguments.of((Object[])new Object[]{null, VerticleMetricsConfigTestValues.TRUE, false}), Arguments.of((Object[])new Object[]{null, VerticleMetricsConfigTestValues.FALSE, false}), Arguments.of((Object[])new Object[]{null, VerticleMetricsConfigTestValues.NULL, false}), Arguments.of((Object[])new Object[]{null, VerticleMetricsConfigTestValues.CONFIG_NULL, false}));
    }

    @ParameterizedTest(name="{index}: MetricsConfig enabled:{0}, verticle metric configuration enabled:{1}, expected:{2}")
    @MethodSource(value={"metricsConfigurationArguments"})
    @Timeout(timeUnit=TimeUnit.SECONDS, value=1)
    @DisplayName(value="Tests the creation of the actual metric configuration.")
    void testMetricsConfiguration(Boolean globalEnabled, VerticleMetricsConfigTestValues verticleMetricsConfigValue, boolean expectedValue) {
        MetricsConfig mc = this.getGlobalMetricsConfig(globalEnabled);
        JsonObject verticleMetricsConfig = verticleMetricsConfigValue.getConfig();
        JsonObject config = new DataVerticleMetricConfig(verticleMetricsConfig).getMetricsConfig(mc);
        Truth.assertThat((Iterable)config).isEqualTo((Object)new JsonObject().put("enabled", (Object)expectedValue));
    }

    private MetricsConfig getGlobalMetricsConfig(Boolean globalEnabled) {
        if (globalEnabled == null) {
            return null;
        }
        return new MetricsConfig().setEnabled(globalEnabled.booleanValue());
    }

    private static class DataVerticleImpl0
    extends DataVerticle<String> {
        public static final String NAME = "ExpectedName0";
        public static final String EXPECTED_RESPONSE = "Hello, I am ExpectedName0";

        private DataVerticleImpl0() {
        }

        public String getName() {
            return NAME;
        }

        public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
            return Future.succeededFuture((Object)EXPECTED_RESPONSE);
        }
    }

    @NeonBeeDeployable
    private static class DataVerticleImpl1
    extends DataVerticle<String> {
        public static final String NAME = "ExpectedName1";
        public static final String EXPECTED_RESPONSE = "Hello, I am ExpectedName1";

        private DataVerticleImpl1() {
        }

        public String getName() {
            return NAME;
        }

        public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
            return Future.succeededFuture((Object)EXPECTED_RESPONSE);
        }
    }

    @NeonBeeDeployable(namespace="DataVerticleTestNamespace2")
    private static class DataVerticleImpl2
    extends DataVerticle<String> {
        public static final String NAME = "ExpectedName2";

        private DataVerticleImpl2() {
        }

        public String getName() {
            return NAME;
        }

        public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
            if (Boolean.parseBoolean(query.getParameter("ping"))) {
                return Future.succeededFuture((Object)"Pong");
            }
            throw new DataException(400, "Bad Request");
        }
    }

    private static enum VerticleMetricsConfigTestValues {
        NULL(null),
        FALSE(false),
        TRUE(true),
        CONFIG_NULL(null);

        private final Boolean value;

        private VerticleMetricsConfigTestValues(Boolean value) {
            this.value = value;
        }

        public JsonObject getConfig() {
            if (this == CONFIG_NULL) {
                return null;
            }
            return this.getConfig(this.value);
        }

        private JsonObject getConfig(Boolean verticleMetricsEnabled) {
            return new JsonObject().put("metrics", (Object)new JsonObject().put("enabled", (Object)verticleMetricsEnabled));
        }
    }

    private static class DataVerticleMetricConfig
    extends DataVerticle<String> {
        private final JsonObject config;

        DataVerticleMetricConfig(JsonObject verticleMetricConfig) {
            this.config = verticleMetricConfig;
        }

        public JsonObject config() {
            return this.config;
        }

        public String getName() {
            throw new UnsupportedOperationException("test implementation");
        }

        public Future<String> retrieveData(DataQuery query, DataMap require, DataContext context) {
            throw new UnsupportedOperationException("test implementation");
        }
    }
}

