/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.health;

import com.google.common.truth.Truth;
import io.neonbee.test.base.NeonBeeTestBase;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class HealthEndpointTest
extends NeonBeeTestBase {
    HealthEndpointTest() {
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should return health info of the default checks")
    void testHealthEndpointData(VertxTestContext testContext) {
        this.createRequest(HttpMethod.GET, "/health").send(testContext.succeeding(response -> testContext.verify(() -> {
            Truth.assertThat((Integer)response.statusCode()).isEqualTo((Object)200);
            JsonObject result = response.bodyAsJsonObject();
            Truth.assertThat((Boolean)result.containsKey("outcome")).isTrue();
            Truth.assertThat((Boolean)result.containsKey("status")).isTrue();
            Truth.assertThat((Boolean)result.containsKey("checks")).isTrue();
            List ids = result.getJsonArray("checks").stream().map(JsonObject.class::cast).map(c -> c.getString("id")).collect(Collectors.toList());
            Truth.assertThat(ids).contains((Object)String.format("node.%s.os.memory", this.getNeonBee().getNodeId()));
            testContext.completeNow();
        })));
    }
}

