/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.metrics;

import com.google.common.truth.Truth;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeOptions;
import io.neonbee.config.EndpointConfig;
import io.neonbee.endpoint.Endpoint;
import io.neonbee.endpoint.metrics.MetricsEndpoint;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import io.vertx.micrometer.backends.BackendRegistries;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
public class NeonBeeMetricsTest {
    private static final int PORT = 10808;
    private static final String HOST = "localhost";
    private static final String TEST_ENDPOINT_URI = "/testendpoint/";
    private static final String METRICS_ENDPOINT_URI = "/metrics/";
    private static TestEndpointHandler testEndpointHandler;
    private static final int OK;

    @BeforeEach
    void init() {
        testEndpointHandler = new TestEndpointHandler();
    }

    @AfterEach
    void reset() {
        testEndpointHandler = null;
    }

    @Test
    @Timeout(value=1, timeUnit=TimeUnit.MINUTES)
    void testCustomMetric(Vertx vertx, VertxTestContext context) {
        Checkpoint prometheusCheckpoint = context.checkpoint(1);
        NeonBeeOptions.Mutable mutable = new NeonBeeOptions.Mutable();
        mutable.setServerPort(Integer.valueOf(10808));
        mutable.setIgnoreClassPath(true);
        mutable.setWorkingDirectory(Path.of("src", "test", "resources", "io", "neonbee", "endpoint", "metrics"));
        NeonBee.create((NeonBeeOptions)mutable).onComplete(context.succeeding(event -> NeonBeeMetricsTest.httpGet(vertx, TEST_ENDPOINT_URI).onComplete(response -> context.succeeding(httpResponse -> context.verify(() -> Truth.assertThat((Integer)((HttpClientResponse)response.result()).statusCode()).isEqualTo((Object)OK)))).compose(response -> NeonBeeMetricsTest.httpGet(vertx, METRICS_ENDPOINT_URI).onComplete(context.succeeding(httpResponse -> {
            context.verify(() -> Truth.assertThat((Integer)httpResponse.statusCode()).isEqualTo((Object)OK));
            httpResponse.bodyHandler(bodyBuffer -> context.verify(() -> {
                Truth.assertThat((String)bodyBuffer.toString()).contains((CharSequence)"TestEndpointCounter_total{TestTag1=\"TestValue\",} 1.0");
                prometheusCheckpoint.flag();
            }));
        })))));
    }

    static Future<HttpClientResponse> httpGet(Vertx vertx, String requestUri) {
        return vertx.createHttpClient().request(HttpMethod.GET, 10808, HOST, requestUri).compose(HttpClientRequest::send);
    }

    static {
        OK = HttpResponseStatus.OK.code();
    }

    private static class TestEndpointHandler
    implements Handler<RoutingContext> {
        private TestEndpointHandler() {
        }

        public void handle(RoutingContext rc) {
            MeterRegistry backendRegistry = BackendRegistries.getDefaultNow();
            double count = Double.NaN;
            if (backendRegistry != null) {
                Counter counter = backendRegistry.counter("TestEndpointCounter", new String[]{"TestTag1", "TestValue"});
                counter.increment();
                count = counter.count();
            }
            rc.response().setStatusCode(OK).end(Double.toString(count));
        }
    }

    public static class TestEndpoint
    implements Endpoint {
        public EndpointConfig getDefaultConfig() {
            return new EndpointConfig().setType(MetricsEndpoint.class.getName()).setBasePath(NeonBeeMetricsTest.TEST_ENDPOINT_URI);
        }

        public Future<Router> createEndpointRouter(Vertx vertx, String basePath, JsonObject config) {
            return Future.succeededFuture((Object)Endpoint.createRouter((Vertx)vertx, (Handler)testEndpointHandler));
        }
    }
}

