/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.metrics;

import com.google.common.truth.Truth;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.neonbee.endpoint.metrics.PrometheusScrapingHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.junit5.VertxExtension;
import io.vertx.micrometer.backends.BackendRegistries;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={VertxExtension.class, MockitoExtension.class})
class PrometheusScrapingHandlerTest {
    PrometheusScrapingHandlerTest() {
    }

    @Test
    void testWithoutPrometheusMeterRegistry() {
        PrometheusScrapingHandler nph = new PrometheusScrapingHandler(null);
        try (MockedStatic br = Mockito.mockStatic(BackendRegistries.class);){
            br.when(BackendRegistries::getDefaultNow).thenReturn((Object)new CompositeMeterRegistry());
            ArgumentCaptor statusCodeCaptor = ArgumentCaptor.forClass(Integer.class);
            ArgumentCaptor statusMessageCaptor = ArgumentCaptor.forClass(String.class);
            RoutingContext rcMock = (RoutingContext)Mockito.mock(RoutingContext.class);
            HttpServerResponse responseMock = (HttpServerResponse)Mockito.mock(HttpServerResponse.class);
            Mockito.when((Object)rcMock.response()).thenReturn((Object)responseMock);
            Mockito.when((Object)responseMock.setStatusCode(((Integer)statusCodeCaptor.capture()).intValue())).thenReturn((Object)responseMock);
            Mockito.when((Object)responseMock.setStatusMessage((String)statusMessageCaptor.capture())).thenReturn((Object)responseMock);
            Mockito.when((Object)responseMock.end()).thenReturn((Object)Future.succeededFuture());
            nph.handle(rcMock);
            Truth.assertThat((Integer)((Integer)statusCodeCaptor.getValue())).isEqualTo((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            Truth.assertThat((String)((String)statusMessageCaptor.getValue())).isEqualTo((Object)"Could not find a PrometheusMeterRegistry");
        }
    }

    @Test
    void testPrometheusMeterRegistry() {
        PrometheusScrapingHandler nph = new PrometheusScrapingHandler("something");
        try (MockedStatic br = Mockito.mockStatic(BackendRegistries.class);){
            br.when(() -> BackendRegistries.getNow((String)((String)ArgumentMatchers.any()))).thenReturn((Object)new PrometheusMeterRegistry(PrometheusConfig.DEFAULT));
            ArgumentCaptor contentTypeCaptor = ArgumentCaptor.forClass(CharSequence.class);
            ArgumentCaptor contentTypeCaptor004 = ArgumentCaptor.forClass(CharSequence.class);
            RoutingContext rcMock = (RoutingContext)Mockito.mock(RoutingContext.class);
            HttpServerResponse responseMock = (HttpServerResponse)Mockito.mock(HttpServerResponse.class);
            Mockito.when((Object)rcMock.response()).thenReturn((Object)responseMock);
            Mockito.when((Object)responseMock.putHeader((CharSequence)contentTypeCaptor.capture(), (CharSequence)contentTypeCaptor004.capture())).thenReturn((Object)responseMock);
            Mockito.when((Object)responseMock.end((String)ArgumentMatchers.any())).thenReturn((Object)Future.succeededFuture());
            nph.handle(rcMock);
            Truth.assertThat((String)((CharSequence)contentTypeCaptor.getValue()).toString()).isEqualTo((Object)HttpHeaders.CONTENT_TYPE.toString());
            Truth.assertThat((String)((CharSequence)contentTypeCaptor004.getValue()).toString()).isEqualTo((Object)"text/plain; version=0.0.4; charset=utf-8");
        }
    }
}

