/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo;

import com.google.common.base.Charsets;
import com.google.common.truth.Truth;
import io.neonbee.endpoint.odatav4.internal.olingo.OlingoEndpointHandler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class OlingoEndpointHandlerTest {
    OlingoEndpointHandlerTest() {
    }

    @Test
    @DisplayName(value="map generic response")
    void checkGenericResponseMapping() {
        ODataResponse odataResponse = new ODataResponse();
        odataResponse.setStatusCode(200);
        odataResponse.setHeader("expected1", "value1");
        odataResponse.setHeader("expected2", "value2");
        odataResponse.setContent((InputStream)new ByteArrayInputStream("expected data".getBytes(Charsets.UTF_8)));
        HttpServerResponse responseMock = (HttpServerResponse)Mockito.mock(HttpServerResponse.class);
        Assertions.assertDoesNotThrow(() -> OlingoEndpointHandler.mapODataResponse((ODataResponse)odataResponse, (HttpServerResponse)responseMock));
        ((HttpServerResponse)Mockito.verify((Object)responseMock)).setStatusCode(200);
        ((HttpServerResponse)Mockito.verify((Object)responseMock)).putHeader("expected1", "value1");
        ((HttpServerResponse)Mockito.verify((Object)responseMock)).putHeader("expected2", "value2");
        ArgumentCaptor endBuffer = ArgumentCaptor.forClass(Buffer.class);
        ((HttpServerResponse)Mockito.verify((Object)responseMock)).end((Buffer)endBuffer.capture());
        Truth.assertThat((String)((Buffer)endBuffer.getValue()).toString()).isEqualTo((Object)"expected data");
    }

    @Test
    @DisplayName(value="map OData response")
    void checkODataResponseMapping() {
        ODataResponse odataResponse = new ODataResponse();
        ODataContent odataContentMock = (ODataContent)Mockito.mock(ODataContent.class);
        ((ODataContent)Mockito.doAnswer(invocation -> {
            ((OutputStream)invocation.getArgument(0)).write("expected data".getBytes(Charsets.UTF_8));
            return null;
        }).when((Object)odataContentMock)).write((OutputStream)ArgumentMatchers.any(OutputStream.class));
        odataResponse.setODataContent(odataContentMock);
        HttpServerResponse responseMock = (HttpServerResponse)Mockito.mock(HttpServerResponse.class);
        Assertions.assertDoesNotThrow(() -> OlingoEndpointHandler.mapODataResponse((ODataResponse)odataResponse, (HttpServerResponse)responseMock));
        ArgumentCaptor endBuffer = ArgumentCaptor.forClass(Buffer.class);
        ((HttpServerResponse)Mockito.verify((Object)responseMock)).end((Buffer)endBuffer.capture());
        Truth.assertThat((String)((Buffer)endBuffer.getValue()).toString()).isEqualTo((Object)"expected data");
    }

    @Test
    @DisplayName(value="test mapToODataRequest")
    void testMapToODataRequest() throws Exception {
        String expectedQuery = "$filter=foo eq 'bar'&$limit=42";
        String expectedPath = "/path";
        String expectedNamespace = "namespace";
        HttpServerRequest request = (HttpServerRequest)Mockito.mock(HttpServerRequest.class);
        Mockito.when((Object)request.path()).thenReturn((Object)expectedPath);
        Mockito.when((Object)request.query()).thenReturn((Object)expectedQuery);
        Mockito.when((Object)request.scheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.host()).thenReturn((Object)"localhost");
        Mockito.when((Object)request.method()).thenReturn((Object)HttpMethod.GET);
        Mockito.when((Object)request.headers()).thenReturn((Object)MultiMap.caseInsensitiveMultiMap());
        RequestBody requestBody = (RequestBody)Mockito.mock(RequestBody.class);
        Mockito.when((Object)requestBody.buffer()).thenReturn((Object)Buffer.buffer((String)""));
        RoutingContext routingContext = (RoutingContext)Mockito.mock(RoutingContext.class);
        Mockito.when((Object)routingContext.request()).thenReturn((Object)request);
        Mockito.when((Object)routingContext.body()).thenReturn((Object)requestBody);
        Mockito.when((Object)routingContext.mountPoint()).thenReturn((Object)"/");
        Mockito.when((Object)routingContext.currentRoute()).thenReturn(null);
        Mockito.when((Object)routingContext.get("correlationId")).thenReturn((Object)"correlId");
        ODataRequest odataReq = OlingoEndpointHandler.mapToODataRequest((RoutingContext)routingContext, (String)expectedNamespace);
        Truth.assertThat((String)odataReq.getRawRequestUri()).isEqualTo((Object)("http://localhost/" + expectedNamespace + expectedPath + "?" + expectedQuery));
        Truth.assertThat((String)odataReq.getRawODataPath()).isEqualTo((Object)expectedPath);
        Truth.assertThat((String)odataReq.getRawQueryPath()).isEqualTo((Object)expectedQuery);
    }
}

