/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.odatav4.internal.olingo.etag;

import com.google.common.truth.Truth;
import io.neonbee.test.base.ODataEndpointTestBase;
import io.neonbee.test.base.ODataRequest;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.http.HttpMethod;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ETagTest
extends ODataEndpointTestBase {
    ETagTest() {
    }

    @Override
    protected List<Path> provideEntityModels() {
        return List.of(ResourceHelper.TEST_RESOURCES.resolveRelated("ProcessorService.csn"));
    }

    static Stream<HttpMethod> withHttpMethods() {
        return Stream.of(HttpMethod.GET, HttpMethod.HEAD);
    }

    @ParameterizedTest
    @MethodSource(value={"withHttpMethods"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="An origin server MUST NOT perform the requested method if the condition evaluates to false.Instead, the origin server MUST respond with either a) the 304 (Not Modified) status code ifthe request method is HEAD or GET.")
    void testIfNoneMatchConditionRequest(HttpMethod method, VertxTestContext testContext) {
        FullQualifiedName fqn = new FullQualifiedName("io.neonbee.processor.ProcessorService", "WillBeIgnored");
        ODataRequest oDataRequest = new ODataRequest(fqn).setMethod(method).setMetadata();
        this.requestOData(oDataRequest).compose(firstResponse -> {
            Truth.assertThat((Integer)firstResponse.statusCode()).isEqualTo((Object)200);
            if (method.equals((Object)HttpMethod.HEAD)) {
                Truth.assertThat((String)firstResponse.bodyAsString()).isNull();
            } else {
                Truth.assertThat((String)firstResponse.bodyAsString()).isNotNull();
            }
            String eTag = firstResponse.getHeader("ETag");
            Truth.assertThat((String)eTag).isNotNull();
            return this.requestOData(oDataRequest.addHeader("If-None-Match", eTag));
        }).onComplete(testContext.succeeding(secondResponse -> {
            testContext.verify(() -> Truth.assertThat((Integer)secondResponse.statusCode()).isEqualTo((Object)304));
            testContext.completeNow();
        }));
    }
}

