/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.endpoint.openapi;

import com.google.common.truth.Truth;
import io.neonbee.config.EndpointConfig;
import io.neonbee.endpoint.openapi.AbstractOpenAPIEndpoint;
import io.neonbee.test.helper.ResourceHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.openapi.RouterBuilder;
import io.vertx.ext.web.openapi.RouterBuilderException;
import io.vertx.junit5.Checkpoint;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
class AbstractOpenAPIEndpointTest {
    private static final Path CONTRACT_PATH = ResourceHelper.TEST_RESOURCES.resolveRelated("petstore.json");

    AbstractOpenAPIEndpointTest() {
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="createEndpointRouter should succeed")
    void testCreateEndpointRouter(Vertx vertx, VertxTestContext testContext) {
        final Checkpoint methodsCheckpoint = testContext.checkpoint(2);
        Checkpoint succeedingCheckpoint = testContext.checkpoint();
        DummyOpenAPIEndpoint dummyEndpoint = new DummyOpenAPIEndpoint(){

            protected Future<String> getOpenAPIContractURL(Vertx vertx, JsonObject config) {
                methodsCheckpoint.flag();
                return Future.succeededFuture((Object)CONTRACT_PATH.toString());
            }

            @Override
            protected Future<Router> createRouter(Vertx vertx, RouterBuilder routerBuilder) {
                methodsCheckpoint.flag();
                return super.createRouter(vertx, routerBuilder);
            }
        };
        dummyEndpoint.createEndpointRouter(vertx, null, null).onComplete(testContext.succeeding(router -> succeedingCheckpoint.flag()));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="createEndpointRouter should fail")
    void testCreateEndpointRouterFailed(Vertx vertx, VertxTestContext testContext) {
        final Checkpoint methodCheckpoint = testContext.checkpoint();
        Checkpoint failingCheckpoint = testContext.checkpoint();
        DummyOpenAPIEndpoint dummyEndpoint = new DummyOpenAPIEndpoint(){

            protected Future<String> getOpenAPIContractURL(Vertx vertx, JsonObject config) {
                methodCheckpoint.flag();
                return Future.succeededFuture((Object)"Invalid");
            }
        };
        dummyEndpoint.createEndpointRouter(vertx, null, null).onComplete(testContext.failing(t -> testContext.verify(() -> {
            Truth.assertThat((Throwable)t).isInstanceOf(RouterBuilderException.class);
            Truth.assertThat((Throwable)t).hasMessageThat().isEqualTo((Object)"Cannot load the spec in path Invalid");
            failingCheckpoint.flag();
        })));
    }

    private static abstract class DummyOpenAPIEndpoint
    extends AbstractOpenAPIEndpoint {
        private DummyOpenAPIEndpoint() {
        }

        public EndpointConfig getDefaultConfig() {
            return null;
        }

        protected Future<Router> createRouter(Vertx vertx, RouterBuilder routerBuilder) {
            return Future.succeededFuture((Object)routerBuilder.createRouter());
        }
    }
}

