/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.entity.EntityModel;
import io.neonbee.entity.EntityModelDefinition;
import io.neonbee.entity.EntityModelManager;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.FileSystemHelper;
import io.neonbee.test.helper.OptionsHelper;
import io.neonbee.test.helper.ResourceHelper;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.olingo.server.api.OData;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.Mockito;

public class EntityModelManagerTest
extends NeonBeeTestBase {
    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should only be allowed to initialize once")
    void testInitialization() {
        Assert.assertThrows(NullPointerException.class, () -> new EntityModelManager(null));
        NeonBee neonBeeMock = (NeonBee)Mockito.mock(NeonBee.class);
        Mockito.when((Object)neonBeeMock.getModelManager()).thenReturn((Object)((EntityModelManager)Mockito.mock(EntityModelManager.class)));
        Assert.assertThrows(IllegalArgumentException.class, () -> new EntityModelManager(neonBeeMock));
        Mockito.when((Object)neonBeeMock.getModelManager()).thenReturn(null);
        EntityModelManager modelManager = (EntityModelManager)Assertions.assertDoesNotThrow(() -> new EntityModelManager(neonBeeMock));
        Truth.assertThat((Object)modelManager.neonBee).isSameInstanceAs((Object)neonBeeMock);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should return the same odata instance for one thread")
    void validateODataBufferInSameThread() {
        OData odata1 = EntityModelManager.getBufferedOData();
        OData odata2 = EntityModelManager.getBufferedOData();
        Truth.assertThat((Object)odata1).isSameInstanceAs((Object)odata2);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should return different odata instances for multiple threads")
    void validateODataBufferInDifferentThreads() {
        CompletableFuture odataFuture1 = new CompletableFuture();
        CompletableFuture odataFuture2 = new CompletableFuture();
        new Thread(() -> odataFuture1.complete(EntityModelManager.getBufferedOData())).start();
        new Thread(() -> odataFuture2.complete(EntityModelManager.getBufferedOData())).start();
        try {
            Truth.assertThat(odataFuture1.get()).isNotSameInstanceAs(odataFuture2.get());
        }
        catch (InterruptedException | ExecutionException e) {
            Assertions.fail((String)"future interrupted exception");
        }
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="lazy model loading: NeonBee should not load any model files after starting")
    void lazyModelLoadingTest(Vertx vertx, VertxTestContext testContext) throws Exception {
        Path workingDir = FileSystemHelper.createTempDirectory();
        WorkingDirectoryBuilder.hollow().addModel(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService1.csn")).addModel(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService2.csn")).build(workingDir);
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles().setWorkingDirectory(workingDir));
        EntityModelManager modelManager = neonBee.getModelManager();
        Truth.assertThat((Map)modelManager.getBufferedModels()).isNull();
        Truth.assertThat((Object)modelManager.getBufferedModel("io.neonbee.test1")).isNull();
        modelManager.getSharedModels().onComplete(testContext.succeeding(models -> testContext.verify(() -> {
            Truth.assertThat((Map)models).isNotNull();
            Truth.assertThat((Map)models).isNotEmpty();
            Truth.assertThat((String)((EntityModel)models.get("io.neonbee.test1")).getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test1.TestService1");
            Truth.assertThat((String)((EntityModel)models.get("io.neonbee.test2")).getEdmxMetadata("io.neonbee.test2.TestService2Cars").getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test2.TestService2Cars");
            Truth.assertThat((Map)modelManager.getBufferedModels()).isNotNull();
            Truth.assertThat((Object)modelManager.getBufferedModel("io.neonbee.test1")).isNotNull();
            modelManager.getSharedModels().onComplete(testContext.succeeding(modelsAgain -> testContext.verify(() -> {
                Truth.assertThat((Map)modelsAgain).isSameInstanceAs(models);
                modelManager.reloadModels().onComplete(testContext.succeeding(reloadModels -> testContext.verify(() -> {
                    Truth.assertThat((Map)reloadModels).isNotSameInstanceAs(models);
                    Truth.assertThat((Map)modelManager.getBufferedModels()).isSameInstanceAs(reloadModels);
                    testContext.completeNow();
                })));
            })));
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if getting single shared models will work for get shared edmx model")
    void getSingleSharedModelsTest(Vertx vertx, VertxTestContext testContext) throws Exception {
        Path workingDir = FileSystemHelper.createTempDirectory();
        WorkingDirectoryBuilder.hollow().addModel(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService1.csn")).addModel(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService2.csn")).build(workingDir);
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles().setWorkingDirectory(workingDir));
        EntityModelManager modelManager = neonBee.getModelManager();
        CompositeFuture.all((Future)modelManager.getSharedModel("io.neonbee.test1"), (Future)modelManager.getSharedModel("io.neonbee.test2")).onComplete(testContext.succeeding(models -> testContext.verify(() -> {
            Truth.assertThat((String)((EntityModel)models.resultAt(0)).getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test1.TestService1");
            Truth.assertThat((String)((EntityModel)models.resultAt(1)).getEdmxMetadata("io.neonbee.test2.TestService2Cars").getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test2.TestService2Cars");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="check if getting single non-existing model will fail for get shared edmx model")
    void getSingleNonExistingSharedModelTest(Vertx vertx, VertxTestContext testContext) {
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx);
        EntityModelManager modelManager = neonBee.getModelManager();
        modelManager.getSharedModel("non-existing").onComplete(testContext.failing(throwable -> testContext.verify(() -> {
            Truth.assertThat((Throwable)throwable).isInstanceOf(NoSuchElementException.class);
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="register / unregister module models")
    void registerModuleModels(Vertx vertx, VertxTestContext testContext) throws IOException {
        Path workingDirectory = this.getNeonBee().getOptions().getWorkingDirectory();
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles().setWorkingDirectory(workingDirectory));
        EntityModelManager modelManager = neonBee.getModelManager();
        Map.Entry<String, byte[]> referenceModel = this.buildModelEntry("ReferenceService.csn");
        Map models = Map.ofEntries(referenceModel);
        Map.Entry<String, byte[]> referenceExtModel = this.buildModelEntry("io.neonbee.reference.ReferenceService.edmx");
        Map extendedModels = Map.ofEntries(referenceExtModel);
        EntityModelDefinition modelDefinition = new EntityModelDefinition(models, extendedModels);
        modelManager.registerModels(modelDefinition).onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((String)modelManager.getBufferedModel("io.neonbee.reference").getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.reference.ReferenceService");
            modelManager.unregisterModels(modelDefinition).onComplete(testContext.succeeding(result2 -> testContext.verify(() -> {
                Truth.assertThat((Object)modelManager.getBufferedModel("io.neonbee.reference")).isNull();
                testContext.completeNow();
            })));
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="register / unregister multiple modules to verify that changing the unmodifiable BUFFERED_MODELS is working correctly.")
    void registerMultipleModuleModels(Vertx vertx, VertxTestContext testContext) throws IOException {
        Path workingDirectory = this.getNeonBee().getOptions().getWorkingDirectory();
        NeonBee neonBee = NeonBeeMockHelper.registerNeonBeeMock(vertx, (NeonBeeOptions)OptionsHelper.defaultOptions().clearActiveProfiles().setWorkingDirectory(workingDirectory));
        EntityModelManager modelManager = neonBee.getModelManager();
        Map.Entry<String, byte[]> referenceModel = this.buildModelEntry("ReferenceService.csn");
        Map referenceModels = Map.ofEntries(referenceModel);
        Map.Entry<String, byte[]> referenceExtModel = this.buildModelEntry("io.neonbee.reference.ReferenceService.edmx");
        Map referenceExtendedModels = Map.ofEntries(referenceExtModel);
        Map.Entry<String, byte[]> testModel = this.buildModelEntry("TestService1.csn");
        Map testModels = Map.ofEntries(testModel);
        Map.Entry<String, byte[]> testExtModel = this.buildModelEntry("io.neonbee.test1.TestService1.edmx");
        Map testExtendedModels = Map.ofEntries(testExtModel);
        EntityModelDefinition definition = new EntityModelDefinition(referenceModels, referenceExtendedModels);
        EntityModelDefinition definition2 = new EntityModelDefinition(testModels, testExtendedModels);
        modelManager.registerModels(definition).compose(result -> modelManager.registerModels(definition2)).onComplete(testContext.succeeding(res -> testContext.verify(() -> {
            Truth.assertThat((String)modelManager.getBufferedModel("io.neonbee.reference").getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.reference.ReferenceService");
            Truth.assertThat((String)modelManager.getBufferedModel("io.neonbee.test1").getEdmxMetadata().getEdm().getEntityContainer().getNamespace()).isEqualTo((Object)"io.neonbee.test1.TestService1");
            modelManager.unregisterModels(definition).compose(res2 -> modelManager.unregisterModels(definition2)).onComplete(testContext.succeeding(result2 -> testContext.verify(() -> {
                Truth.assertThat((Object)modelManager.getBufferedModel("io.neonbee.reference")).isNull();
                Truth.assertThat((Object)modelManager.getBufferedModel("AnnotatedService")).isNull();
                testContext.completeNow();
            })));
        })));
    }

    private Map.Entry<String, byte[]> buildModelEntry(String modelName) throws IOException {
        return Map.entry("models/" + modelName, ResourceHelper.TEST_RESOURCES.getRelated(modelName).getBytes());
    }
}

