/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.entity;

import com.google.common.truth.Truth;
import io.neonbee.NeonBeeOptions;
import io.neonbee.NeonBeeProfile;
import io.neonbee.entity.EntityWrapper;
import io.neonbee.test.base.NeonBeeTestBase;
import io.neonbee.test.helper.ResourceHelper;
import io.neonbee.test.helper.WorkingDirectoryBuilder;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

class EntityWrapperTest
extends NeonBeeTestBase {
    private static final EntityWrapper TEST_USER_WRAPPER = new EntityWrapper("io.neonbee.test2.TestService2Users.TestUsers", EntityWrapperTest.createTestUser());
    private static final Buffer TEST_USER_WRAPPER_SERIALIZED = Buffer.buffer((String)"{\"entityType\":{\"namespace\":\"io.neonbee.test2.TestService2Users\",\"name\":\"TestUsers\"},\"entity\":\"{\\\"@odata.context\\\":\\\"$metadata#TestUsers\\\",\\\"@odata.metadataEtag\\\":\\\"\\\\\\\"2f85d83fa1f93164cf4d3252ca72023e\\\\\\\"\\\",\\\"value\\\":[{\\\"ID\\\":\\\"ID\\\",\\\"name\\\":\\\"NAME\\\",\\\"description\\\":\\\"DESCRIPTION\\\"}]}\"}");

    EntityWrapperTest() {
    }

    private static Entity createTestUser() {
        Entity testUser = new Entity().addProperty(new Property("Edm.String", "name", ValueType.PRIMITIVE, (Object)"NAME")).addProperty(new Property("Edm.String", "description", ValueType.PRIMITIVE, (Object)"DESCRIPTION")).addProperty(new Property("Edm.String", "ID", ValueType.PRIMITIVE, (Object)"ID"));
        testUser.setType("io.neonbee.test2.TestService2Users.TestUsers");
        return testUser;
    }

    @Override
    protected void adaptOptions(TestInfo testInfo, NeonBeeOptions.Mutable options) {
        options.addActiveProfile(NeonBeeProfile.NO_WEB);
    }

    @Override
    protected WorkingDirectoryBuilder provideWorkingDirectoryBuilder(TestInfo testInfo, VertxTestContext testContext) {
        return WorkingDirectoryBuilder.standard().addModel(ResourceHelper.TEST_RESOURCES.resolveRelated("TestService2.csn"));
    }

    @Test
    @DisplayName(value="Check if equals works as expected")
    void testEquals() {
        EntityWrapper fooBarEmptyString = new EntityWrapper("Foo.Bar", (Entity)null);
        EntityWrapper fooBarEmptyFQN = new EntityWrapper(new FullQualifiedName("Foo", "Bar"), (Entity)null);
        EntityWrapper hodorHodorEmptyFQN = new EntityWrapper(new FullQualifiedName("Hodor", "Hodor"), (Entity)null);
        Truth.assertThat((Object)fooBarEmptyString).isEqualTo((Object)fooBarEmptyFQN);
        Truth.assertThat((Object)hodorHodorEmptyFQN).isNotEqualTo((Object)fooBarEmptyString);
        Truth.assertThat((Object)hodorHodorEmptyFQN).isNotEqualTo((Object)fooBarEmptyFQN);
        Entity hodor = new Entity().addProperty(new Property(null, "Name", ValueType.PRIMITIVE, (Object)"Hodor"));
        Entity sam = new Entity().addProperty(new Property(null, "Name", ValueType.PRIMITIVE, (Object)"Sam"));
        EntityWrapper firstNamesHodor = new EntityWrapper("First.Name", hodor);
        EntityWrapper firstNamesSam = new EntityWrapper("First.Name", sam);
        Truth.assertThat((Object)firstNamesHodor).isNotEqualTo((Object)firstNamesSam);
        Truth.assertThat((Object)firstNamesHodor).isEqualTo((Object)new EntityWrapper("First.Name", hodor));
        Truth.assertThat((Object)firstNamesSam).isNotEqualTo((Object)new EntityWrapper("Hodor.Hodor", sam));
    }

    @Test
    @DisplayName(value="Check if toBuffer works as expected")
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testToBuffer(VertxTestContext testContext) {
        this.getNeonBee().getModelManager().reloadModels().onComplete(testContext.succeeding(map -> testContext.verify(() -> {
            Buffer buffer = TEST_USER_WRAPPER.toBuffer(this.getNeonBee().getVertx());
            Truth.assertThat((Iterable)buffer.toJsonObject()).isEqualTo((Object)TEST_USER_WRAPPER_SERIALIZED.toJsonObject());
            testContext.completeNow();
        })));
    }

    @Test
    @DisplayName(value="Check if fromBuffer works as expected")
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    void testFromBuffer(VertxTestContext testContext) {
        this.getNeonBee().getModelManager().reloadModels().onComplete(testContext.succeeding(map -> testContext.verify(() -> {
            EntityWrapper decodedWrapper = EntityWrapper.fromBuffer((Vertx)this.getNeonBee().getVertx(), (Buffer)TEST_USER_WRAPPER_SERIALIZED);
            Truth.assertThat((Object)decodedWrapper.getTypeName()).isEqualTo((Object)TEST_USER_WRAPPER.getTypeName());
            Truth.assertThat((Object)decodedWrapper.getEntity().getProperty("name").getValue()).isEqualTo(TEST_USER_WRAPPER.getEntity().getProperty("name").getValue());
            Truth.assertThat((Object)decodedWrapper.getEntity().getProperty("description").getValue()).isEqualTo(TEST_USER_WRAPPER.getEntity().getProperty("description").getValue());
            Truth.assertThat((Object)decodedWrapper.getEntity().getProperty("ID").getValue()).isEqualTo(TEST_USER_WRAPPER.getEntity().getProperty("ID").getValue());
            testContext.completeNow();
        })));
    }
}

