/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeMockHelper;
import io.neonbee.NeonBeeOptions;
import io.neonbee.config.HealthConfig;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.health.AbstractHealthCheck;
import io.neonbee.health.HealthCheckException;
import io.neonbee.health.HealthCheckRegistry;
import io.neonbee.test.helper.OptionsHelper;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.Status;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@ExtendWith(value={VertxExtension.class})
class AbstractHealthCheckTest {
    private static final String DUMMY_ID = "dummy/check-0";
    private static final JsonObject HEALTH_CONFIG = new JsonObject().put("enabled", (Object)true);
    private Vertx vertxMock;
    private AbstractHealthCheck hc;
    private FileSystem fsMock;

    AbstractHealthCheckTest() {
    }

    @BeforeEach
    void setUp() {
        this.vertxMock = NeonBeeMockHelper.defaultVertxMock();
        this.fsMock = this.vertxMock.fileSystem();
        NeonBeeMockHelper.registerNeonBeeMock(this.vertxMock, (NeonBeeOptions)OptionsHelper.defaultOptions(), new NeonBeeConfig().setHealthConfig(new HealthConfig().setEnabled(true)));
        this.hc = this.createDummyHealthCheck(true, true, null);
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="cannot get a health check result if health check was not registered to registry")
    void testResultFails(VertxTestContext testContext) {
        this.hc.result().onComplete(testContext.failing(t -> testContext.verify(() -> {
            Truth.assertThat((String)t.getMessage()).contains((CharSequence)"must be registered");
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="can register global checks")
    void testRegisterGlobalCheck(VertxTestContext testContext) throws HealthCheckException {
        HealthCheckRegistry registry = (HealthCheckRegistry)Mockito.mock(HealthCheckRegistry.class);
        Mockito.when((Object)registry.registerGlobalCheck(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (Function)ArgumentMatchers.any(), (JsonObject)ArgumentMatchers.any(JsonObject.class))).thenReturn((Object)this.hc);
        this.hc.register(registry).onComplete(testContext.succeeding(check -> testContext.verify(() -> {
            Truth.assertThat((Boolean)check.isGlobal()).isTrue();
            ((HealthCheckRegistry)Mockito.verify((Object)registry)).registerGlobalCheck((String)ArgumentMatchers.eq((Object)DUMMY_ID), ArgumentMatchers.eq((long)0L), (Function)ArgumentMatchers.any(), (JsonObject)ArgumentMatchers.eq((Object)HEALTH_CONFIG));
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="can register node-specific checks")
    void testRegisterNodeCheck(VertxTestContext testContext) throws HealthCheckException {
        HealthCheckRegistry registry = (HealthCheckRegistry)Mockito.mock(HealthCheckRegistry.class);
        this.hc = this.createDummyHealthCheck(false, true, null);
        Mockito.when((Object)registry.registerNodeCheck(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), (Function)ArgumentMatchers.any(), (JsonObject)ArgumentMatchers.any())).thenReturn((Object)this.hc);
        this.hc.register(registry).onComplete(testContext.succeeding(check -> testContext.verify(() -> {
            Truth.assertThat((Boolean)check.isGlobal()).isFalse();
            ((HealthCheckRegistry)Mockito.verify((Object)registry)).registerNodeCheck((String)ArgumentMatchers.eq((Object)DUMMY_ID), ArgumentMatchers.eq((long)0L), (Function)ArgumentMatchers.any(), (JsonObject)ArgumentMatchers.eq((Object)HEALTH_CONFIG));
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="can merge a config from file in config directory with the default config")
    void testMergeConfigs(VertxTestContext testContext) {
        Mockito.when((Object)this.fsMock.readFile(ArgumentMatchers.anyString())).thenReturn((Object)Future.succeededFuture((Object)new JsonObject().put("enabled", (Object)false).put("new-random-key", (Object)"something").toBuffer()));
        Mockito.when((Object)this.vertxMock.fileSystem()).thenReturn((Object)this.fsMock);
        this.hc.mergeHealthCheckConfig().onComplete(testContext.succeeding(config -> testContext.verify(() -> {
            String path = NeonBee.get((Vertx)this.vertxMock).getOptions().getConfigDirectory().resolve(this.hc.getClass().getName()) + ".yaml";
            ((FileSystem)Mockito.verify((Object)this.fsMock)).readFile((String)ArgumentMatchers.eq((Object)path));
            Truth.assertThat((Boolean)config.getBoolean("enabled")).isFalse();
            Truth.assertThat((String)config.getString("new-random-key")).isEqualTo((Object)"something");
            testContext.completeNow();
        })));
    }

    static Stream<Arguments> provideConfigArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{Future.succeededFuture((Object)new JsonObject().toBuffer()), "config from file is empty"}), Arguments.of((Object[])new Object[]{Future.succeededFuture((Object)Buffer.buffer()), "config from file is an empty buffer"}), Arguments.of((Object[])new Object[]{Future.failedFuture((String)"oops"), "retrieving config fails"}));
    }

    @ParameterizedTest(name="{index} => {1}")
    @MethodSource(value={"provideConfigArguments"})
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should return default config, if")
    void testConfigNotExisting(Future<Buffer> expected, String testCase, VertxTestContext testContext) {
        Mockito.when((Object)this.fsMock.readFile(ArgumentMatchers.anyString())).thenReturn(expected);
        Mockito.when((Object)this.vertxMock.fileSystem()).thenReturn((Object)this.fsMock);
        this.hc.mergeHealthCheckConfig().onComplete(testContext.succeeding(config -> testContext.verify(() -> {
            String path = NeonBee.get((Vertx)this.vertxMock).getOptions().getConfigDirectory().resolve(this.hc.getClass().getName()) + ".yaml";
            ((FileSystem)Mockito.verify((Object)this.fsMock)).readFile((String)ArgumentMatchers.eq((Object)path));
            Truth.assertThat((Iterable)config).isEqualTo((Object)AbstractHealthCheck.DEFAULT_HEALTH_CHECK_CONFIG.mutableCopy());
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="can merge a config with the default config")
    void testConfigRetrievalFails(VertxTestContext testContext) {
        Mockito.when((Object)this.fsMock.readFile(ArgumentMatchers.anyString())).thenReturn((Object)Future.failedFuture((String)"oops"));
        Mockito.when((Object)this.vertxMock.fileSystem()).thenReturn((Object)this.fsMock);
        this.hc.mergeHealthCheckConfig().onComplete(testContext.succeeding(config -> testContext.verify(() -> {
            String path = NeonBee.get((Vertx)this.vertxMock).getOptions().getConfigDirectory().resolve(this.hc.getClass().getName()) + ".yaml";
            ((FileSystem)Mockito.verify((Object)this.fsMock)).readFile((String)ArgumentMatchers.eq((Object)path));
            Truth.assertThat((Iterable)config).isEqualTo((Object)AbstractHealthCheck.DEFAULT_HEALTH_CHECK_CONFIG.mutableCopy());
            testContext.completeNow();
        })));
    }

    private AbstractHealthCheck createDummyHealthCheck(final boolean global, final boolean ok, final JsonObject data) {
        return new AbstractHealthCheck(NeonBee.get((Vertx)this.vertxMock)){

            public Function<NeonBee, Handler<Promise<Status>>> createProcedure() {
                return nb -> p -> p.complete((Object)new Status().setOk(ok).setData(data));
            }

            public String getId() {
                return AbstractHealthCheckTest.DUMMY_ID;
            }

            public boolean isGlobal() {
                return global;
            }
        };
    }
}

