/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.health;

import com.google.common.truth.Truth;
import io.neonbee.NeonBee;
import io.neonbee.config.HealthConfig;
import io.neonbee.config.NeonBeeConfig;
import io.neonbee.health.MemoryHealthCheck;
import io.neonbee.health.internal.MemoryStats;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.healthchecks.HealthChecks;
import io.vertx.junit5.Timeout;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;

@ExtendWith(value={VertxExtension.class})
class MemoryHealthCheckTest {
    private NeonBee neonBee;
    private MemoryHealthCheck memoryHealthCheck;
    private HealthChecks checks;

    MemoryHealthCheckTest() {
    }

    @BeforeEach
    void setUp(Vertx vertx) {
        this.checks = HealthChecks.create((Vertx)vertx);
        this.memoryHealthCheck = new MemoryHealthCheck(NeonBee.get((Vertx)vertx));
        this.memoryHealthCheck.memoryStats = new MemoryStats(){

            public long getMaxHeap() {
                return 512000000L;
            }

            public long getCommittedHeap() {
                return 256000000L;
            }

            public long getFreeHeap() {
                return 128000000L;
            }

            public long getUsedHeap() {
                return this.getCommittedHeap() - this.getFreeHeap();
            }
        };
        this.neonBee = (NeonBee)Mockito.mock(NeonBee.class);
        Mockito.when((Object)this.neonBee.getConfig()).thenReturn((Object)new NeonBeeConfig().setHealthConfig(new HealthConfig()));
        Truth.assertThat((Boolean)this.memoryHealthCheck.isGlobal()).isFalse();
        Truth.assertThat((String)this.memoryHealthCheck.getId()).startsWith("os.");
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should set health check to up if used memory is below configured threshold of health config")
    void testCreateProcedureHealthy(VertxTestContext testContext) {
        this.memoryHealthCheck.config = new JsonObject().put("criticalThresholdPercentage", (Object)26);
        this.checks.register("os.memory", (Handler)this.memoryHealthCheck.createProcedure().apply(this.neonBee));
        this.checks.checkStatus("os.memory").onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((Integer)result.getData().size()).isEqualTo((Object)3);
            Truth.assertThat((String)result.getData().getString("freeHeapMemory")).isEqualTo((Object)"122 MB");
            Truth.assertThat((String)result.getData().getString("memoryUsedOfTotalPercentage")).matches("50[,.]{1}00%");
            Truth.assertThat((String)result.getData().getString("memoryUsedOfMaxPercentage")).matches("25[,.]{1}00%");
            Truth.assertThat((Boolean)result.getUp()).isTrue();
            testContext.completeNow();
        })));
    }

    @Test
    @Timeout(value=2, timeUnit=TimeUnit.SECONDS)
    @DisplayName(value="should set health check to down if used memory is above configured threshold of health config")
    void testCreateProcedureUnhealthy(VertxTestContext testContext) {
        this.memoryHealthCheck.config = new JsonObject().put("criticalThresholdPercentage", (Object)24);
        this.checks.register("os.memory", (Handler)this.memoryHealthCheck.createProcedure().apply(this.neonBee));
        this.checks.checkStatus("os.memory").onComplete(testContext.succeeding(result -> testContext.verify(() -> {
            Truth.assertThat((Integer)result.getData().size()).isEqualTo((Object)3);
            Truth.assertThat((String)result.getData().getString("freeHeapMemory")).isEqualTo((Object)"122 MB");
            Truth.assertThat((String)result.getData().getString("memoryUsedOfTotalPercentage")).matches("50[,.]{1}00%");
            Truth.assertThat((String)result.getData().getString("memoryUsedOfMaxPercentage")).matches("25[,.]{1}00%");
            Truth.assertThat((Boolean)result.getUp()).isFalse();
            testContext.completeNow();
        })));
    }
}

